/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ru.turikhay.tlauncher.rmo.TLauncher;

public class CrashSignatureContainer {
    private static final int universalExitCode = 0;
    private Map<String, String> variables = new LinkedHashMap<String, String>();
    private List<CrashSignature> signatures = new ArrayList<CrashSignature>();

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public List<CrashSignature> getSignatures() {
        return this.signatures;
    }

    public String getVariable(String key) {
        return this.variables.get(key);
    }

    public Pattern getPattern(String key) {
        return Pattern.compile(this.variables.get(key));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\nvariables='" + this.variables + "',\nsignatures='" + this.signatures + "'}";
    }

    public class CrashSignature {
        private String name;
        private String version;
        private String path;
        private String pattern;
        private int exit;
        private boolean fake;
        private boolean forge;
        private Pattern versionPattern;
        private Pattern linePattern;

        public String getName() {
            return this.name;
        }

        public Pattern getVersion() {
            return this.versionPattern;
        }

        public boolean hasVersion() {
            return this.version != null;
        }

        public boolean isFake() {
            return this.fake;
        }

        public Pattern getPattern() {
            return this.linePattern;
        }

        public boolean hasPattern() {
            return this.pattern != null;
        }

        public String getPath() {
            return this.path;
        }

        public int getExitCode() {
            return this.exit;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{name='" + this.name + "', version='" + this.version + "', path='" + this.path + "', pattern='" + this.pattern + "', exitCode=" + this.exit + ", forge=" + this.forge + ", versionPattern='" + this.versionPattern + "', linePattern='" + this.linePattern + "'}";
        }
    }

    private static class CrashSignatureListSimpleDeserializer {
        private final Gson defaultContext = TLauncher.getGson();
        private Map<String, String> variables;
        private String forgePrefix;

        private CrashSignatureListSimpleDeserializer() {
        }

        public void setVariables(Map<String, String> vars) {
            this.variables = vars == null ? new HashMap() : vars;
            this.forgePrefix = this.variables.containsKey("forge") ? this.variables.get("forge") : "";
        }

        public List<CrashSignature> deserialize(JsonElement elem) throws JsonParseException {
            List signatureList = (List)this.defaultContext.fromJson(elem, new TypeToken(){}.getType());
            for (CrashSignature signature : signatureList) {
                this.analyzeSignature(signature);
            }
            return signatureList;
        }

        private CrashSignature analyzeSignature(CrashSignature signature) {
            if (signature.name != null && !signature.name.isEmpty()) {
                String varVal;
                String varName;
                String pattern;
                if (signature.version != null) {
                    pattern = signature.version;
                    for (Map.Entry<String, String> en : this.variables.entrySet()) {
                        varName = en.getKey();
                        varVal = en.getValue();
                        pattern = pattern.replace("${" + varName + "}", varVal);
                    }
                    signature.versionPattern = Pattern.compile(pattern);
                }
                if (signature.pattern != null) {
                    pattern = signature.pattern;
                    for (Map.Entry<String, String> en : this.variables.entrySet()) {
                        varName = en.getKey();
                        varVal = en.getValue();
                        pattern = pattern.replace("${" + varName + "}", varVal);
                    }
                    if (signature.forge) {
                        pattern = this.forgePrefix + pattern;
                    }
                    signature.linePattern = Pattern.compile(pattern);
                }
                if (signature.versionPattern == null && signature.linePattern == null && signature.exit == 0) {
                    throw new JsonParseException("Useless signature found: " + signature.name);
                }
                return signature;
            }
            throw new JsonParseException("Invalid name: \"" + signature.name + "\"");
        }
    }

    static class CrashSignatureContainerDeserializer
    implements JsonDeserializer<CrashSignatureContainer> {
        private final CrashSignatureListSimpleDeserializer listDeserializer = new CrashSignatureListSimpleDeserializer();
        private final Gson defaultContext = TLauncher.getGson();

        CrashSignatureContainerDeserializer() {
        }

        @Override
        public CrashSignatureContainer deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = element.getAsJsonObject();
            Map rawVariables = (Map)this.defaultContext.fromJson(object.get("variables"), new TypeToken(){}.getType());
            LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
            for (Map.Entry list : rawVariables.entrySet()) {
                String varName = (String)list.getKey();
                String varVal = (String)list.getValue();
                for (Map.Entry<String, String> en : variables.entrySet()) {
                    String replaceName = en.getKey();
                    String replaceVal = en.getValue();
                    varVal = varVal.replace("${" + replaceName + "}", replaceVal);
                }
                variables.put(varName, varVal);
            }
            this.listDeserializer.setVariables(variables);
            List<CrashSignature> signatures1 = this.listDeserializer.deserialize(object.get("signatures"));
            CrashSignatureContainer list1 = new CrashSignatureContainer();
            list1.variables = variables;
            list1.signatures = signatures1;
            return list1;
        }
    }
}

