/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.log;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.util.ValidateUtil;
import ru.turikhay.tlauncher.ui.util.ViewlUtil;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.error.ErrorUtil;
import ru.turikhay.util.salf.connection.TransferLogImpl;

public class LogFrame
extends JFrame {
    private JPanel contentPane;
    private JTextField emailField;
    private static final Object FLAG = new Object();

    public LogFrame(final JFrame parent, Throwable errorMessage) {
        this.setBounds(100, 100, 400, 366);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.setLocation(ViewlUtil.calculatePosition(parent, this.getSize()));
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setTitle(Localizable.get("log.form.title"));
        SwingUtil.setFavicons(this);
        JPanel panel = new JPanel();
        panel.setBounds(0, 11, 400, 316);
        this.contentPane.add(panel);
        panel.setLayout(null);
        JLabel lblEmail = new JLabel(Localizable.get("check.email.name"));
        lblEmail.setBounds(10, 10, 334, 15);
        panel.add(lblEmail);
        this.emailField = new JTextField();
        this.emailField.setBounds(10, 25, 207, 20);
        panel.add(this.emailField);
        this.emailField.setColumns(10);
        JLabel descriptionErrorLabel = new JLabel(Localizable.get("log.email.error.description"));
        descriptionErrorLabel.setBounds(10, 55, 334, 15);
        panel.add(descriptionErrorLabel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBounds(10, 70, 380, 80);
        panel.add(scrollPane);
        final JTextArea descriptionErrorArea = new JTextArea();
        descriptionErrorArea.setLineWrap(true);
        descriptionErrorArea.setRows(5);
        descriptionErrorArea.setColumns(10);
        scrollPane.setViewportView(descriptionErrorArea);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setHorizontalScrollBarPolicy(31);
        scrollPane_1.setViewportBorder(UIManager.getBorder("TextPane.border"));
        scrollPane_1.setBounds(10, 175, 380, 96);
        panel.add(scrollPane_1);
        JTextArea outputErrorArea = new JTextArea();
        outputErrorArea.setColumns(10);
        outputErrorArea.setRows(5);
        outputErrorArea.setLineWrap(true);
        scrollPane_1.setViewportView(outputErrorArea);
        outputErrorArea.setText(ErrorUtil.exchnageErrorFullStack(errorMessage));
        outputErrorArea.setEditable(false);
        outputErrorArea.setEnabled(true);
        JButton btnNewButton = new JButton(Localizable.get("log.form.send"));
        btnNewButton.setBounds(61, 282, 134, 23);
        panel.add(btnNewButton);
        JLabel outputLabelError = new JLabel(Localizable.get("log.email.error.issue"));
        outputLabelError.setBounds(10, 161, 334, 14);
        panel.add(outputLabelError);
        JButton noSendButton = new JButton(Localizable.get("log.form.send.no"));
        noSendButton.setBounds(205, 282, 128, 23);
        panel.add(noSendButton);
        parent.setEnabled(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogFrame.this.releaseLog(parent);
            }
        });
        btnNewButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LogFrame.this.emailField.getText().isEmpty() && !ValidateUtil.validateEmail(LogFrame.this.emailField.getText())) {
                    JOptionPane.showMessageDialog(LogFrame.this, "check.email.input");
                } else {
                    LogFrame.this.releaseLog(parent);
                    LogFrame.this.setVisible(false);
                    parent.setEnabled(true);
                    Object object = FLAG;
                    synchronized (object) {
                        U.log("[log]  email=" + LogFrame.this.emailField.getText());
                        U.log("[log]  message=" + descriptionErrorArea.getText());
                        TransferLogImpl transferLog = new TransferLogImpl();
                        try {
                            String ex = FileUtil.archiveFile(MinecraftUtil.getWorkingDirectory().getPath() + File.separator + "logs" + File.separator + "log4jFiles");
                            if (null == ex) {
                                throw new NullPointerException("Path zip file contains null ");
                            }
                            transferLog.sendFiles(ex);
                            Alert.showMonologError(Localizable.get().get("alert.error.send.log.success"), 1);
                        }
                        catch (IOException | NullPointerException var7) {
                            StringWriter stringWriter = new StringWriter();
                            var7.printStackTrace(new PrintWriter(stringWriter));
                            U.log(stringWriter.toString());
                            Alert.showMonologError(Localizable.get().get("alert.error.send.log.unsuccess"), 0);
                        }
                        LogFrame.this.dispose();
                    }
                }
            }
        });
        noSendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFrame.this.releaseLog(parent);
            }
        });
    }

    private void releaseLog(JFrame parent) {
        parent.setEnabled(true);
        this.dispose();
    }
}

