/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.center.LoginHelperTheme;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.swing.ResizeableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;

public class LoginFormHelper
extends ExtendedLayeredPane
implements LocalizableComponent {
    private static final int MARGIN = 5;
    private static final int EDGE = 50;
    private final DefaultScene defaultScene;
    private final LoginForm loginForm;
    private final LoginFormHelperTip[] tips;
    private LoginFormHelperState state;
    private static final LoginHelperTheme loginHelperTheme = new LoginHelperTheme();
    private static final Insets loginHelperInsets = new Insets(7, 15, 7, 15);

    public LoginFormHelper(DefaultScene scene) {
        this.defaultScene = scene;
        this.loginForm = scene.loginForm;
        for (LoginFormHelperTip tip : this.tips = new LoginFormHelperTip[]{new LoginFormHelperTip("username", this.loginForm.input, Position.UP), new LoginFormHelperTip("versions", this.loginForm.input.version, Position.DOWN), new LoginFormHelperTip("play", this.loginForm.play, Position.UP)}) {
            tip.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoginFormHelper.this.setState(LoginFormHelperState.NONE);
                }
            });
        }
        this.add(this.tips);
        this.setState(LoginFormHelperState.NONE);
    }

    public LoginFormHelperState getState() {
        return this.state;
    }

    public void setState(LoginFormHelperState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.updateTips();
        this.setVisible(state != LoginFormHelperState.NONE);
    }

    @Override
    public void onResize() {
        this.setSize(this.loginForm.getWidth() + 100, this.loginForm.getHeight() + 100);
        this.setLocation(this.loginForm.getX() - 50, this.loginForm.getY() - 50);
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof ResizeableComponent)) continue;
            ((ResizeableComponent)((Object)comp)).onResize();
        }
        this.updateTips();
    }

    protected void updateTips() {
        for (LoginFormHelperTip tip : this.tips) {
            int var13;
            tip.setVisible(false);
            if (this.state == LoginFormHelperState.NONE) continue;
            tip.label.setText("loginform.helper." + tip.name);
            int pH = tip.component.getHeight();
            Point pP = SwingUtil.getRelativeLocation(this.loginForm, tip.component);
            FontMetrics fm = tip.label.getFontMetrics(tip.label.getFont());
            Insets i = tip.getInsets();
            int tH = i.top + i.bottom + fm.getHeight();
            int tW = i.left + i.right + fm.stringWidth(tip.label.getText());
            int x = 50 + pP.x - 5;
            int y = 50;
            switch (SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$login$LoginFormHelper$Position[tip.position.ordinal()]) {
                case 1: {
                    var13 = y + pP.y + pH + 5;
                    break;
                }
                case 2: {
                    var13 = y + (pP.y - 5 - tH);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown position: " + (Object)((Object)tip.position));
                }
            }
            tip.setBounds(x, var13, tW, tH);
            tip.setVisible(true);
        }
    }

    @Override
    public void updateLocale() {
        this.updateTips();
    }

    public static enum LoginFormHelperState {
        NONE,
        SHOWN;

    }

    public static enum Position {
        UP,
        DOWN;

    }

    private class LoginFormHelperTip
    extends CenterPanel {
        final String name;
        final JComponent component;
        final Position position;
        final LocalizableLabel label;

        LoginFormHelperTip(String name, JComponent comp, Position pos) {
            super(loginHelperTheme, loginHelperInsets);
            if (name == null) {
                throw new NullPointerException("Name is NULL!");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name is empty!");
            }
            if (comp == null) {
                throw new NullPointerException("Component is NULL!");
            }
            if (pos == null) {
                throw new NullPointerException("Position is NULL!");
            }
            this.name = name.toLowerCase();
            this.component = comp;
            this.position = pos;
            this.label = new LocalizableLabel();
            this.add((Component)this.label);
            this.setBackground(U.shiftAlpha(this.getTheme().getBackground(), 255));
        }
    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$ru$turikhay$tlauncher$ui$login$LoginFormHelper$Position = new int[Position.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$login$LoginFormHelper$Position[Position.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$login$LoginFormHelper$Position[Position.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

