/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;

public class ImageButton
extends ExtendedButton {
    private static final long serialVersionUID = 1L;
    protected Image image;
    protected ImageRotation rotation = ImageRotation.CENTER;
    private int margin = 4;
    private boolean pressed;

    protected ImageButton() {
        this.initListeners();
    }

    public ImageButton(String label, Image image, ImageRotation rotation, int margin) {
        super(label);
        this.image = image;
        this.rotation = rotation;
        this.margin = margin;
        this.initImage();
        this.initListeners();
    }

    public ImageButton(String label, Image image, ImageRotation rotation) {
        this(label, image, rotation, 4);
    }

    public ImageButton(String label, Image image) {
        this(label, image, ImageRotation.CENTER);
    }

    public ImageButton(Image image) {
        this((String)null, image);
    }

    public ImageButton(String imagepath) {
        this((String)null, ImageButton.loadImage(imagepath));
    }

    public ImageButton(String label, String imagepath, ImageRotation rotation, int margin) {
        this(label, ImageButton.loadImage(imagepath), rotation, margin);
    }

    public ImageButton(String label, String imagepath, ImageRotation rotation) {
        this(label, ImageButton.loadImage(imagepath), rotation);
    }

    public ImageButton(String label, String imagepath) {
        this(label, ImageButton.loadImage(imagepath));
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.initImage();
        this.repaint();
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public int getImageMargin() {
        return this.margin;
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        this.paint(g);
    }

    @Override
    public void paint(Graphics g0) {
        super.paint(g0);
        if (this.image != null) {
            int ix1;
            int twidth;
            Graphics2D g = (Graphics2D)g0;
            String text = this.getText();
            boolean drawtext = text != null && text.length() > 0;
            FontMetrics fm = g.getFontMetrics();
            float opacity = this.isEnabled() ? 1.0f : 0.5f;
            int width = this.getWidth();
            int height = this.getHeight();
            int rmargin = this.margin;
            int offset = this.pressed ? 1 : 0;
            int iwidth = this.image.getWidth(null);
            int iheight = this.image.getHeight(null);
            boolean ix = false;
            int iy = height / 2 - iheight / 2;
            if (drawtext) {
                twidth = fm.stringWidth(text);
            } else {
                rmargin = 0;
                twidth = 0;
            }
            switch (SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$swing$ImageButton$ImageRotation[this.rotation.ordinal()]) {
                case 1: {
                    ix1 = width / 2 - twidth / 2 - iwidth - rmargin;
                    break;
                }
                case 2: {
                    ix1 = width / 2 - iwidth / 2;
                    break;
                }
                case 3: {
                    ix1 = width / 2 + twidth / 2 + rmargin;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown rotation!");
                }
            }
            Composite c = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, opacity));
            g.drawImage(this.image, ix1 + offset, iy + offset, null);
            g.setComposite(c);
            this.pressed = false;
        }
    }

    protected static Image loadImage(String path) {
        return ImageCache.getImage(path);
    }

    protected void initImage() {
        if (this.image != null) {
            this.setPreferredSize(new Dimension(this.image.getWidth(null) + 10, this.image.getHeight(null) + 10));
        }
    }

    private void initListeners() {
        this.initImage();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ImageButton.this.pressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ImageButton.this.pressed = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ImageButton.this.pressed = false;
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public static enum ImageRotation {
        LEFT,
        CENTER,
        RIGHT;

    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$ru$turikhay$tlauncher$ui$swing$ImageButton$ImageRotation = new int[ImageRotation.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$swing$ImageButton$ImageRotation[ImageRotation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$swing$ImageButton$ImageRotation[ImageRotation.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$swing$ImageButton$ImageRotation[ImageRotation.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

