/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.downloader.AbortedDownloadException;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionSyncInfoContainer;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Unblockable;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.swing.ImageButton;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerListener;
import ru.turikhay.tlauncher.ui.versions.VersionList;

public class VersionDownloadButton
extends ImageButton
implements VersionHandlerListener,
Unblockable {
    private static final String SELECTION_BLOCK = "selection";
    private static final String PREFIX = "version.manager.downloader.";
    private static final String WARNING = "version.manager.downloader.warning.";
    private static final String WARNING_TITLE = "version.manager.downloader.warning.title";
    private static final String WARNING_FORCE = "version.manager.downloader.warning.force.";
    private static final String ERROR = "version.manager.downloader.error.";
    private static final String ERROR_TITLE = "version.manager.downloader.error.title";
    private static final String INFO = "version.manager.downloader.info.";
    private static final String INFO_TITLE = "version.manager.downloader.info.title";
    private static final String MENU = "version.manager.downloader.menu.";
    final VersionHandler handler;
    final Blockable blockable;
    private final JPopupMenu menu;
    private final LocalizableMenuItem ordinary;
    private final LocalizableMenuItem force;
    private ButtonState state;
    private boolean downloading;
    private boolean aborted;
    boolean forceDownload;

    VersionDownloadButton(VersionList list) {
        this.handler = list.handler;
        this.blockable = new Blockable(){

            @Override
            public void block(Object reason) {
                VersionDownloadButton.this.setEnabled(false);
            }

            @Override
            public void unblock(Object reason) {
                VersionDownloadButton.this.setEnabled(true);
            }
        };
        this.menu = new JPopupMenu();
        this.ordinary = new LocalizableMenuItem("version.manager.downloader.menu.ordinary");
        this.ordinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionDownloadButton.this.forceDownload = false;
                VersionDownloadButton.this.onDownloadCalled();
            }
        });
        this.menu.add(this.ordinary);
        this.force = new LocalizableMenuItem("version.manager.downloader.menu.force");
        this.force.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionDownloadButton.this.forceDownload = true;
                VersionDownloadButton.this.onDownloadCalled();
            }
        });
        this.menu.add(this.force);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionDownloadButton.this.onPressed();
            }
        });
        this.setState(ButtonState.DOWNLOAD);
        this.handler.addListener(this);
    }

    void setState(ButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.setImage(state.image);
    }

    void onPressed() {
        switch (SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionDownloadButton$ButtonState[this.state.ordinal()]) {
            case 1: {
                this.onDownloadPressed();
                break;
            }
            case 2: {
                this.onStopCalled();
            }
        }
    }

    void onDownloadPressed() {
        this.menu.show(this, 0, this.getHeight());
    }

    void onDownloadCalled() {
        if (this.state != ButtonState.DOWNLOAD) {
            throw new IllegalStateException();
        }
        this.handler.thread.startThread.iterate();
    }

    void onStopCalled() {
        if (this.state != ButtonState.STOP) {
            throw new IllegalStateException();
        }
        this.handler.thread.stopThread.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startDownload() {
        this.aborted = false;
        List<VersionSyncInfo> list = this.handler.getSelectedList();
        if (list != null && !list.isEmpty()) {
            int countLocal = 0;
            VersionSyncInfo local = null;
            for (VersionSyncInfo manager : list) {
                if (!this.forceDownload) continue;
                if (!manager.hasRemote()) {
                    Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.local", manager.getID()));
                    return;
                }
                if (!manager.isUpToDate() || !manager.isInstalled()) continue;
                ++countLocal;
                local = manager;
            }
            if (countLocal > 0) {
                Object i$;
                String var19;
                String var17 = Localizable.get(WARNING_TITLE);
                if (countLocal == 1) {
                    var19 = "single";
                    i$ = local.getID();
                } else {
                    var19 = "multiply";
                    i$ = countLocal;
                }
                if (!Alert.showQuestion(var17, Localizable.get(WARNING_FORCE + var19, i$))) {
                    return;
                }
            }
            ArrayList<VersionSyncInfoContainer> var18 = new ArrayList<VersionSyncInfoContainer>();
            VersionManager var20 = TLauncher.getInstance().getVersionManager();
            try {
                this.downloading = true;
                for (VersionSyncInfo container : list) {
                    VersionSyncInfoContainer errors;
                    block27: {
                        try {
                            container.resolveCompleteVersion(var20, this.forceDownload);
                            errors = var20.downloadVersion(container, false, this.forceDownload);
                            if (!this.aborted) break block27;
                            return;
                        }
                        catch (Exception var15) {
                            Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.getting", container.getID()), var15);
                            this.downloading = false;
                            return;
                        }
                    }
                    if (errors.getList().isEmpty()) continue;
                    var18.add(errors);
                }
                if (var18.isEmpty()) {
                    Alert.showMessage(Localizable.get(INFO_TITLE), Localizable.get("version.manager.downloader.info.no-needed"));
                    return;
                }
                if (var18.size() > 1) {
                    DownloadableContainer.removeDuplicates(var18);
                }
                if (this.aborted) {
                    return;
                }
                Iterator<VersionSyncInfo> var21 = var18.iterator();
                while (true) {
                    if (!var21.hasNext()) {
                        this.handler.downloading = list;
                        this.handler.onVersionDownload(list);
                        this.handler.downloader.startDownloadAndWait();
                        break;
                    }
                    DownloadableContainer var22 = (DownloadableContainer)((Object)var21.next());
                    this.handler.downloader.add(var22);
                }
            }
            finally {
                this.downloading = false;
            }
            this.handler.downloading.clear();
            for (VersionSyncInfoContainer var23 : var18) {
                List<Throwable> var24 = var23.getErrors();
                VersionSyncInfo version = var23.getVersion();
                if (var24.isEmpty()) {
                    try {
                        var20.getLocalList().saveVersion(version.getCompleteVersion(this.forceDownload));
                        continue;
                    }
                    catch (IOException var14) {
                        Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.saving", version.getID()), var14);
                        return;
                    }
                }
                if (var24.get(0) instanceof AbortedDownloadException) continue;
                Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.downloading", version.getID()), var24);
            }
            this.handler.refresh();
        }
    }

    void stopDownload() {
        this.aborted = true;
        if (this.downloading) {
            this.handler.downloader.stopDownloadAndWait();
        }
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
        if (!this.downloading) {
            this.blockable.unblock(SELECTION_BLOCK);
        }
    }

    @Override
    public void onVersionDeselected() {
        if (!this.downloading) {
            this.blockable.block(SELECTION_BLOCK);
        }
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    public static enum ButtonState {
        DOWNLOAD("down.png"),
        STOP("cancel.png");

        final Image image;

        private ButtonState(String image) {
            this.image = ImageCache.getImage(image);
        }
    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionDownloadButton$ButtonState = new int[ButtonState.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionDownloadButton$ButtonState[ButtonState.DOWNLOAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionDownloadButton$ButtonState[ButtonState.STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

