/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.command;

import com.pau101.wallpaper.Wallpaper;
import com.pau101.wallpaper.item.ItemWallpaper;
import com.pau101.wallpaper.network.play.server.S01ProxyPacketWallpaperChange;
import com.pau101.wallpaper.proxy.ClientProxy;
import com.pau101.wallpaper.proxy.CommonProxy;
import com.pau101.wallpaper.utils.EnumFacingHelper;
import com.pau101.wallpaper.utils.MiscUtils;
import com.pau101.wallpaper.world.WallpaperBlockData;
import com.pau101.wallpaper.world.WallpaperData;
import com.pau101.wallpaper.world.WallpaperManager;
import com.pau101.wallpaper.world.WallpaperType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class CommandSetWallpaper
extends CommandBase {
    public String func_71517_b() {
        return "setwallpaper";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.setwallpaper.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 4) {
            int x = sender.func_82114_b().field_71574_a;
            int y = sender.func_82114_b().field_71572_b;
            int z = sender.func_82114_b().field_71573_c;
            x = MathHelper.func_76128_c((double)CommandSetWallpaper.func_110666_a((ICommandSender)sender, (double)x, (String)args[0]));
            y = MathHelper.func_76128_c((double)CommandSetWallpaper.func_110666_a((ICommandSender)sender, (double)y, (String)args[1]));
            z = MathHelper.func_76128_c((double)CommandSetWallpaper.func_110666_a((ICommandSender)sender, (double)z, (String)args[2]));
            World world = sender.func_130014_f_();
            if (!world.func_72899_e(x, y, z)) {
                throw new CommandException("commands.setblock.outOfWorld", new Object[0]);
            }
            EnumFacing face = CommandSetWallpaper.getEnumFacing(args[3]);
            if (face == null) {
                throw new CommandException("commands.setwallpaper.invalidFace", new Object[]{args[3].toLowerCase()});
            }
            if (face.func_96559_d() != 0) {
                throw new CommandException("commands.setwallpaper.nonVerticalFace", new Object[0]);
            }
            if (!world.func_147439_a(x, y, z).func_149662_c()) {
                throw new CommandException("commands.setwallpaper.nonOpaqueCube", new Object[0]);
            }
            WallpaperType wallpaper = WallpaperType.byName(args[4]);
            if (wallpaper == null) {
                throw new CommandException("commands.setwallpaper.invalidWallpaper", new Object[]{args[4]});
            }
            boolean remote = world.field_72995_K;
            WallpaperManager mgr = remote ? ClientProxy.getWallpaperManager() : CommonProxy.getWallpaperManager();
            int part = 0;
            if (args.length > 6) {
                int partX = MiscUtils.wrap(CommandSetWallpaper.func_71526_a((ICommandSender)sender, (String)args[5]), 3);
                int partY = MiscUtils.wrap(CommandSetWallpaper.func_71526_a((ICommandSender)sender, (String)args[6]), 4);
                part = WallpaperData.combine(partX, partY);
            } else {
                part = ItemWallpaper.fitPuzzle(mgr, world, x, y, z, face);
            }
            WallpaperBlockData wallpapersAtPos = mgr.getWallpaperBlockData(world, x, y, z);
            WallpaperData newWallpaperData = new WallpaperData(wallpaper, part);
            if (wallpapersAtPos == null) {
                CommandSetWallpaper.setWallpaper(remote, world, x, y, z, face, newWallpaperData);
            } else {
                WallpaperData existingWallpaper = wallpapersAtPos.getWallpaper(face);
                if (existingWallpaper == WallpaperData.NONE) {
                    CommandSetWallpaper.setWallpaper(remote, world, x, y, z, face, newWallpaperData);
                } else {
                    if (existingWallpaper.equals(newWallpaperData)) {
                        throw new CommandException("commands.setwallpaper.noChange", new Object[0]);
                    }
                    CommandSetWallpaper.setWallpaper(remote, world, x, y, z, face, newWallpaperData);
                }
            }
        } else {
            throw new CommandException("commands.setwallpaper.usage", new Object[0]);
        }
        CommandSetWallpaper.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.setwallpaper.success", (Object[])new Object[0]);
    }

    public static void setWallpaper(boolean remote, World world, int x, int y, int z, EnumFacing face, WallpaperData wallpaper) {
        if (remote) {
            ClientProxy.setWallpaper(world, x, y, z, face, wallpaper);
        } else {
            CommonProxy.setWallpaper(world, x, y, z, face, wallpaper);
            Wallpaper.networkManager.sendPacketToClientsWatchingChunk(x >> 4, z >> 4, world, new S01ProxyPacketWallpaperChange(x, y, z, wallpaper, face), new Entity[0]);
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        switch (args.length) {
            default: {
                return null;
            }
            case 4: {
                return CommandSetWallpaper.getPossibleFaceValues();
            }
            case 5: 
        }
        return CommandSetWallpaper.getPossibleWallpaperValues();
    }

    public static EnumFacing getEnumFacing(String name) {
        EnumFacing[] faces;
        for (EnumFacing potentialFace : faces = EnumFacing.values()) {
            if (!EnumFacingHelper.getName(potentialFace).equalsIgnoreCase(name)) continue;
            return potentialFace;
        }
        return null;
    }

    public static List<String> getPossibleFaceValues() {
        EnumFacing[] faces = EnumFacing.values();
        ArrayList<String> possibleFaceValues = new ArrayList<String>();
        for (EnumFacing face : faces) {
            if (face.func_96559_d() != 0) continue;
            possibleFaceValues.add(EnumFacingHelper.getName(face));
        }
        return possibleFaceValues;
    }

    private static List<String> getPossibleWallpaperValues() {
        WallpaperType[] wallpapers = WallpaperType.values();
        ArrayList<String> possibleWallpaperValues = new ArrayList<String>();
        for (WallpaperType wallpaper : wallpapers) {
            if (!wallpaper.isEnabled()) continue;
            possibleWallpaperValues.add(wallpaper.getFileName());
        }
        return possibleWallpaperValues;
    }
}

