/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Mappings {
    private static final Map<String, String> NAMES = new HashMap<String, String>();
    private static final Map<String, String> DESCRIPTIONS = new HashMap<String, String>();

    public static String getName(String key) {
        String name = NAMES.get(key);
        if (name == null) {
            throw new Error("Can't find name for " + key);
        }
        return name;
    }

    public static String getFieldName(String key) {
        String name = NAMES.get(key);
        if (name == null) {
            throw new Error("Can't find field name for " + key);
        }
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public static String getClassName(String key) {
        String name = NAMES.get(key);
        if (name == null) {
            throw new Error("Can't find class name for " + key);
        }
        return name.replace('/', '.');
    }

    public static String getMethodName(String key) {
        String name = NAMES.get(key);
        if (name == null) {
            throw new Error("Can't find method name for " + key);
        }
        return name.substring(name.lastIndexOf(47) + 1, name.length());
    }

    public static String getDesc(String key) {
        String desc = DESCRIPTIONS.get(key);
        if (desc == null) {
            throw new Error("Can't find desc for " + key);
        }
        return desc;
    }

    private Mappings() {
    }

    static {
        Properties mappings = new Properties();
        try {
            mappings.load(Mappings.class.getResourceAsStream("/mappings.txt"));
            for (Map.Entry<Object, Object> mapping : mappings.entrySet()) {
                String name = (String)mapping.getValue();
                String[] parts = name.split(" ");
                if (parts.length > 1) {
                    NAMES.put((String)mapping.getKey(), parts[0]);
                    DESCRIPTIONS.put((String)mapping.getKey(), parts[1]);
                    continue;
                }
                NAMES.put((String)mapping.getKey(), name);
            }
        }
        catch (Throwable e) {
            throw new Error("Unable to load mappings!", e);
        }
    }
}

