/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.core;

import com.pau101.wallpaper.core.Mappings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WallpaperClassTransformer
implements IClassTransformer {
    private String blockModelRendererClass = Mappings.getClassName("blockModelRenderer");
    private String blockRendererDispatcherClass = Mappings.getClassName("blockRendererDispatcher");
    private String entityFXClass = Mappings.getClassName("entityFX");
    private String effectRendererClass = Mappings.getClassName("effectRenderer");
    private String worldClass = Mappings.getClassName("world");
    private String minecraft = Mappings.getClassName("minecraft");
    private String renderBlocks = Mappings.getClassName("renderBlocks");
    private String blockModelRendererName = Mappings.getName("blockModelRenderer");
    private String textureAtlasSpriteName = Mappings.getName("textureAtlasSprite");
    private String entityDiggingFXName = Mappings.getName("entityDiggingFX");
    private String effectRendererName = Mappings.getName("effectRenderer");
    private String worldName = Mappings.getName("world");
    private String enumFacingName = Mappings.getName("enumFacing");
    private String blockName = Mappings.getName("block");
    private String iBlockAccessName = Mappings.getName("iBlockAccess");
    private String iIconName = Mappings.getName("iIcon");
    private String addEffectName = Mappings.getMethodName("addEffect");
    private String addEffectDesc = Mappings.getDesc("addEffect");
    private String setBlockName = Mappings.getMethodName("setBlock");
    private String setBlockDesc = Mappings.getDesc("setBlock");
    private String onPickBlockName = Mappings.getMethodName("onPickBlock");
    private String onPickBlockDesc = Mappings.getDesc("onPickBlock");
    private String getBlockIconName = Mappings.getMethodName("getBlockIcon");
    private String getBlockIconDesc = Mappings.getDesc("getBlockIcon");
    private String worldObjName = Mappings.getFieldName("effectRendererWorldObj");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals(this.renderBlocks)) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (int i = 0; i < classNode.methods.size(); ++i) {
                MethodNode methodNode = (MethodNode)classNode.methods.get(i);
                if (!methodNode.name.equals(this.getBlockIconName) || !methodNode.desc.equals(this.getBlockIconDesc)) continue;
                methodNode.instructions.clear();
                methodNode.localVariables.clear();
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 5));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 6));
                methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/pau101/wallpaper/proxy/ClientProxy", "getBlockIcon", String.format("(L%s;L%s;IIII)L%s;", this.blockName, this.iBlockAccessName, this.iIconName), false));
                methodNode.instructions.add((AbstractInsnNode)new InsnNode(176));
                break;
            }
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if (name.equals(this.entityFXClass)) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            MethodNode methodNode = (MethodNode)classNode.methods.get(16);
            InsnList insnList = methodNode.instructions;
            for (int i = 0; i < insnList.size(); ++i) {
                AbstractInsnNode node = insnList.get(i);
                if (node.getType() != 2 || node.getOpcode() != 25) continue;
                VarInsnNode varNode = (VarInsnNode)node;
                if (varNode.var != 1) continue;
                insnList.insert(node, (AbstractInsnNode)new MethodInsnNode(184, "com/pau101/wallpaper/proxy/ClientProxy", "getSprite", String.format("(L%s;)L%s;", this.iIconName, this.iIconName), false));
            }
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if (name.equals(this.effectRendererClass)) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            MethodNode methodNode = (MethodNode)classNode.methods.get(classNode.methods.size() - 4);
            InsnList insnList = methodNode.instructions;
            boolean addedSetup = false;
            boolean addedReset = false;
            for (int i = 0; i < insnList.size(); ++i) {
                AbstractInsnNode node = insnList.get(i);
                if (node.getType() == 3 && node.getOpcode() == 187 && !addedSetup) {
                    TypeInsnNode typeNode = (TypeInsnNode)node;
                    if (!typeNode.desc.equals(this.entityDiggingFXName)) continue;
                    InsnList newInsn = new InsnList();
                    newInsn.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                    newInsn.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newInsn.add((AbstractInsnNode)new FieldInsnNode(180, this.effectRendererName, this.worldObjName, "L" + this.worldName + ";"));
                    newInsn.add((AbstractInsnNode)new VarInsnNode(21, 1));
                    newInsn.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    newInsn.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    newInsn.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    newInsn.add((AbstractInsnNode)new FieldInsnNode(184, "com/pau101/wallpaper/proxy/ClientProxy", "setupDiggingFXWallpaperData", String.format("(L%s;IIII)V", this.worldName)));
                    insnList.insertBefore(node.getPrevious(), newInsn);
                    addedSetup = true;
                    continue;
                }
                if (node.getType() != 5 || node.getOpcode() != 182 || addedReset) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)node;
                if (!methodInsnNode.name.equals(this.addEffectName) || !methodInsnNode.desc.equals(this.addEffectDesc)) continue;
                insnList.insert(node, (AbstractInsnNode)new FieldInsnNode(184, "com/pau101/wallpaper/proxy/ClientProxy", "resetOverrideEntityFXSprite", "()V"));
                addedReset = true;
            }
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if (name.equals(this.worldClass)) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (int i = 0; i < classNode.methods.size(); ++i) {
                MethodNode method = (MethodNode)classNode.methods.get(i);
                if (!method.name.equals(this.setBlockName) || !method.desc.equals(this.setBlockDesc)) continue;
                this.patchWorldBlockChange(method.instructions);
                break;
            }
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if (name.equals(this.minecraft)) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            block4: for (int i = 0; i < classNode.methods.size(); ++i) {
                MethodNode methodNode = (MethodNode)classNode.methods.get(i);
                if (!methodNode.name.equals(this.onPickBlockName) || !methodNode.desc.equals(this.onPickBlockDesc)) continue;
                InsnList insnList = methodNode.instructions;
                for (int n = 0; n < insnList.size(); ++n) {
                    AbstractInsnNode node = insnList.get(n);
                    if (node.getType() != 5 || node.getOpcode() != 184) continue;
                    ((MethodInsnNode)node).owner = "com/pau101/wallpaper/proxy/ClientProxy";
                    continue block4;
                }
            }
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private boolean patchWorldBlockChange(InsnList insnList) {
        for (int i = 0; i < insnList.size(); ++i) {
            AbstractInsnNode node = insnList.get(i);
            if (node.getType() != 14) continue;
            FrameNode frameNode = (FrameNode)node;
            if (frameNode.type != 1 || frameNode.local.size() != 3) continue;
            InsnList newInsn = new InsnList();
            newInsn.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInsn.add((AbstractInsnNode)new VarInsnNode(21, 1));
            newInsn.add((AbstractInsnNode)new VarInsnNode(21, 2));
            newInsn.add((AbstractInsnNode)new VarInsnNode(21, 3));
            newInsn.add((AbstractInsnNode)new VarInsnNode(25, 4));
            newInsn.add((AbstractInsnNode)new MethodInsnNode(184, "com/pau101/wallpaper/proxy/CommonProxy", "onBlockStateChange", String.format("(L%s;IIIL%s;)V", this.worldName, this.blockName), false));
            insnList.insert(node, newInsn);
            return false;
        }
        return true;
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        WallpaperClassTransformer.copy(input, output);
        return output.toByteArray();
    }

    private static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8024];
        int read = 0;
        long totalRead = 0L;
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
        }
        return totalRead;
    }
}

