/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.item;

import com.pau101.wallpaper.Wallpaper;
import com.pau101.wallpaper.network.play.server.S01ProxyPacketWallpaperChange;
import com.pau101.wallpaper.proxy.ClientProxy;
import com.pau101.wallpaper.proxy.CommonProxy;
import com.pau101.wallpaper.utils.EnumFacingHelper;
import com.pau101.wallpaper.world.WallpaperData;
import com.pau101.wallpaper.world.WallpaperManager;
import com.pau101.wallpaper.world.WallpaperType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemWallpaper
extends Item {
    private IIcon[] icons;

    public ItemWallpaper() {
        this.func_77655_b("wallpaper");
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(Wallpaper.creativeTabsWallpaper);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        WallpaperType[] wallpapers = WallpaperType.values();
        this.icons = new IIcon[wallpapers.length];
        for (int i = 0; i < wallpapers.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("wallpaper:" + wallpapers[i].getFileName());
        }
    }

    public IIcon func_77617_a(int metadata) {
        return this.icons[metadata < 0 || metadata >= this.icons.length ? 0 : metadata];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ) {
        EnumFacing face = EnumFacingHelper.getEnumFacing(sideHit);
        if (face.func_96559_d() != 0) {
            return false;
        }
        Block blockOn = world.func_147439_a(x, y, z);
        if (!CommonProxy.validBlock(blockOn)) {
            return false;
        }
        WallpaperManager mgr = world.field_72995_K ? ClientProxy.getWallpaperManager() : CommonProxy.getWallpaperManager();
        WallpaperData wallpaper = new WallpaperData(WallpaperType.getWallpaper(stack.func_77960_j()), ItemWallpaper.fitPuzzle(mgr, world, x, y, z, face));
        if (world.field_72995_K) {
            WallpaperData existingWallpaper = ClientProxy.getWallpaper(world, x, y, z, face);
            if (existingWallpaper == WallpaperData.NONE) {
                ClientProxy.setWallpaper(world, x, y, z, face, wallpaper);
                return true;
            }
        } else {
            WallpaperData existingWallpaper = CommonProxy.getWallpaper(world, x, y, z, face);
            if (existingWallpaper == WallpaperData.NONE) {
                CommonProxy.setWallpaper(world, x, y, z, face, wallpaper);
                Wallpaper.networkManager.sendPacketToClientsWatchingChunk(x >> 4, z >> 4, world, new S01ProxyPacketWallpaperChange(x, y, z, wallpaper, face), new Entity[0]);
                --stack.field_77994_a;
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "wallpaper:wallpaper.place", 1.0f, world.field_73012_v.nextFloat() * 0.3f + 1.0f);
                return true;
            }
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + '.' + WallpaperType.getWallpaper(stack.func_77960_j()).getUnlocalizedName();
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        WallpaperType[] wallpapers = WallpaperType.values();
        int length = wallpapers.length;
        for (int i = 0; i < length; ++i) {
            if (!wallpapers[i].isEnabled()) continue;
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    public static int fitPuzzle(WallpaperManager mgr, World world, int x, int y, int z, EnumFacing face) {
        int partX = 0;
        int partY = 0;
        WallpaperData top = mgr.getWallpaper(world, x, y + 1, z, face);
        WallpaperData down = mgr.getWallpaper(world, x, y - 1, z, face);
        EnumFacing leftFace = EnumFacingHelper.rotateY(face);
        int lx = x + leftFace.func_82601_c();
        int lz = z + leftFace.func_82599_e();
        WallpaperData left = mgr.getWallpaper(world, lx, y, lz, face);
        EnumFacing rightFace = EnumFacingHelper.rotateYCCW(face);
        lx = x + rightFace.func_82601_c();
        lz = z + rightFace.func_82599_e();
        WallpaperData right = mgr.getWallpaper(world, lx, y, lz, face);
        if (left != WallpaperData.NONE) {
            partX = left.getPartX() + 1;
            partY = left.getPartY();
        } else if (right != WallpaperData.NONE) {
            partX = right.getPartX() - 1;
            partY = right.getPartY();
        } else if (top != WallpaperData.NONE) {
            partX = top.getPartX();
            partY = top.getPartY() + 1;
        } else if (down != WallpaperData.NONE) {
            partX = down.getPartX();
            partY = down.getPartY() - 1;
        } else {
            WallpaperData cornerLeft = mgr.getWallpaper(world, x, y, z, leftFace);
            WallpaperData cornerRight = mgr.getWallpaper(world, x, y, z, rightFace);
            if (cornerLeft != WallpaperData.NONE) {
                partX = cornerLeft.getPartX() - 1;
                partY = cornerLeft.getPartY();
            } else if (cornerRight != WallpaperData.NONE) {
                partX = cornerRight.getPartX() + 1;
                partY = cornerRight.getPartY();
            } else {
                lx = x - face.func_82601_c();
                lz = z - face.func_82599_e();
                int px = lx - leftFace.func_82601_c();
                int pz = lz - leftFace.func_82599_e();
                WallpaperData sideLeft = mgr.getWallpaper(world, px, y, pz, rightFace);
                px = lx - rightFace.func_82601_c();
                pz = lz - rightFace.func_82599_e();
                WallpaperData sideRight = mgr.getWallpaper(world, px, y, pz, leftFace);
                if (sideLeft != WallpaperData.NONE) {
                    partX = sideLeft.getPartX() - 1;
                    partY = sideLeft.getPartY();
                } else if (sideRight != WallpaperData.NONE) {
                    partX = sideRight.getPartX() + 1;
                    partY = sideRight.getPartY();
                } else if (!world.func_147437_c(lx, y - 1, lz)) {
                    partY = 3;
                }
            }
        }
        return WallpaperData.combine(partX, partY);
    }
}

