/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.network;

import com.google.common.collect.BiMap;
import com.pau101.wallpaper.world.WallpaperBlockData;
import com.pau101.wallpaper.world.WallpaperData;
import com.pau101.wallpaper.world.WallpaperType;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;

public abstract class ProxyPacket {
    public static ProxyPacket generatePacket(BiMap<Integer, Class<? extends ProxyPacket>> packetMap, int id) {
        try {
            Class packetClass = (Class)packetMap.get((Object)id);
            return packetClass == null ? null : (ProxyPacket)packetClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract void writePacketData(PacketBuffer var1);

    public abstract void readPacketData(PacketBuffer var1);

    public abstract void processPacket(INetHandler var1);

    protected static void writeWallpaperData(PacketBuffer buffer, WallpaperData wallpaperData) {
        WallpaperType type = wallpaperData.getType();
        buffer.writeInt(type == null ? -1 : type.ordinal());
        buffer.writeInt(wallpaperData.getPart());
    }

    protected static void writeWallpaperBlockData(PacketBuffer buffer, WallpaperBlockData wallpaperBlockData) {
        WallpaperData[] wallpapers = wallpaperBlockData.getWallpapers();
        int length = wallpapers.length;
        buffer.writeInt(length);
        for (int i = 0; i < length; ++i) {
            ProxyPacket.writeWallpaperData(buffer, wallpapers[i]);
        }
    }

    protected static WallpaperData readWallpaperData(PacketBuffer buffer) {
        int part;
        int typeInt = buffer.readInt();
        WallpaperType type = typeInt == -1 ? null : WallpaperType.getWallpaper(typeInt);
        WallpaperData wallpaper = new WallpaperData(type, part = buffer.readInt());
        if (wallpaper.equals(WallpaperData.NONE)) {
            wallpaper = WallpaperData.NONE;
        }
        return wallpaper;
    }

    protected static WallpaperBlockData readWallpaperBlockData(PacketBuffer buffer) {
        WallpaperBlockData wallpaperBlockData = new WallpaperBlockData();
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            wallpaperBlockData.setWallpaper(i, ProxyPacket.readWallpaperData(buffer));
        }
        return wallpaperBlockData;
    }
}

