/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.network;

import com.pau101.wallpaper.network.ProxyPacket;
import com.pau101.wallpaper.utils.MiscUtils;
import com.pau101.wallpaper.world.WallpaperData;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;

public abstract class ProxyPacketWallpaper
extends ProxyPacket {
    protected int x;
    protected int y;
    protected int z;
    protected WallpaperData data;
    protected EnumFacing face;

    public ProxyPacketWallpaper() {
    }

    public ProxyPacketWallpaper(int x, int y, int z, WallpaperData data, EnumFacing face) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.data = data;
        this.face = face;
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ProxyPacketWallpaper.writeWallpaperData(buffer, this.data);
        buffer.writeInt(this.face == null ? -1 : this.face.ordinal());
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.data = ProxyPacketWallpaper.readWallpaperData(buffer);
        int faceOrdinal = buffer.readInt();
        this.face = faceOrdinal == -1 ? null : MiscUtils.safeEnumGet(EnumFacing.class, faceOrdinal);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public WallpaperData getData() {
        return this.data;
    }

    public EnumFacing getFace() {
        return this.face;
    }

    @Override
    public abstract void processPacket(INetHandler var1);
}

