/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.network.play.server;

import com.pau101.wallpaper.network.play.client.C00ProxyPacketRequestChunkWallpapers;
import com.pau101.wallpaper.proxy.ClientProxy;
import com.pau101.wallpaper.utils.IntKeyedHashMap;
import com.pau101.wallpaper.world.WallpaperBlockData;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;

public class S02ProxyPacketReturnChunkWallpapers
extends C00ProxyPacketRequestChunkWallpapers {
    private IntKeyedHashMap<WallpaperBlockData> wallpapers;

    public S02ProxyPacketReturnChunkWallpapers() {
    }

    public S02ProxyPacketReturnChunkWallpapers(int chunkX, int chunkZ, IntKeyedHashMap wallpapers) {
        super(chunkX, chunkZ);
        this.wallpapers = wallpapers;
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        super.writePacketData(buffer);
        int size = this.wallpapers.size();
        buffer.writeInt(size);
        for (IntKeyedHashMap.Entry<WallpaperBlockData> entry : this.wallpapers.entrySet()) {
            buffer.writeInt(entry.getKey());
            S02ProxyPacketReturnChunkWallpapers.writeWallpaperBlockData(buffer, entry.getValue());
        }
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        super.readPacketData(buffer);
        this.wallpapers = new IntKeyedHashMap();
        int size = buffer.readInt();
        while (size-- > 0) {
            int index = buffer.readInt();
            WallpaperBlockData data = S02ProxyPacketReturnChunkWallpapers.readWallpaperBlockData(buffer);
            this.wallpapers.put(index, data);
        }
    }

    @Override
    public void processPacket(INetHandler netHandler) {
        ClientProxy.onReturnChunkWallpapers(this, netHandler);
    }

    public IntKeyedHashMap<WallpaperBlockData> getWallpapers() {
        return this.wallpapers;
    }
}

