/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.proxy;

import com.pau101.wallpaper.Wallpaper;
import com.pau101.wallpaper.network.play.server.S01ProxyPacketWallpaperChange;
import com.pau101.wallpaper.network.play.server.S02ProxyPacketReturnChunkWallpapers;
import com.pau101.wallpaper.proxy.CommonProxy;
import com.pau101.wallpaper.utils.EnumFacingHelper;
import com.pau101.wallpaper.utils.IntKeyedHashMap;
import com.pau101.wallpaper.world.WallpaperBlockData;
import com.pau101.wallpaper.world.WallpaperData;
import com.pau101.wallpaper.world.WallpaperEventHandlerClient;
import com.pau101.wallpaper.world.WallpaperManager;
import com.pau101.wallpaper.world.WallpaperType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private static WallpaperManager wallpaperManager = new WallpaperManager();
    private static final String[] COLUMN_NAMES = new String[]{"left", "middle", "right"};
    private static final String[] ROW_NAMES = new String[]{"top", "upperMiddle", "lowerMiddle", "bottom"};
    private static Map<WallpaperType, TextureAtlasSprite[]> spriteMap;
    private static ThreadLocal<TextureAtlasSprite> overrideEntityFXSprite;

    public static void unload(Chunk chunk) {
        wallpaperManager.remove(chunk);
    }

    public static void onReturnChunkWallpapers(S02ProxyPacketReturnChunkWallpapers pkt, INetHandler netHandler) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Chunk chunk = world.func_72964_e(pkt.getXPosition(), pkt.getZPosition());
        IntKeyedHashMap<WallpaperBlockData> wallpapers = pkt.getWallpapers();
        if (wallpapers.size() == 0) {
            return;
        }
        wallpaperManager.put(chunk, wallpapers);
        int minX = 16;
        int minY = 256;
        int minZ = 16;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (int pos : wallpapers.keySet()) {
            int x = WallpaperManager.getX(pos);
            int y = WallpaperManager.getY(pos);
            int z = WallpaperManager.getZ(pos);
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        world.func_147458_c(chunk.field_76635_g * 16 + minX, minY, chunk.field_76647_h * 16 + minZ, chunk.field_76635_g * 16 + maxX, maxY, chunk.field_76647_h * 16 + maxZ);
    }

    public static void onWallpaperPlace(S01ProxyPacketWallpaperChange pkt, INetHandler handler) {
        if (pkt.getFace() == null) {
            ClientProxy.removeWallpapers((World)Minecraft.func_71410_x().field_71441_e, pkt.getX(), pkt.getY(), pkt.getZ());
        } else {
            ClientProxy.setWallpaper((World)Minecraft.func_71410_x().field_71441_e, pkt.getX(), pkt.getY(), pkt.getZ(), pkt.getFace(), pkt.getData());
        }
    }

    public static void onTextureStitchPre(TextureStitchEvent.Pre e) {
        if (e.map.func_130086_a() != 0) {
            return;
        }
        WallpaperType[] wallpapers = WallpaperType.values();
        for (int i = 0; i < wallpapers.length; ++i) {
            WallpaperType wallpaper = wallpapers[i];
            if (!wallpaper.isEnabled()) continue;
            for (int x = 0; x < COLUMN_NAMES.length; ++x) {
                String c = COLUMN_NAMES[x];
                for (int y = 0; y < ROW_NAMES.length; ++y) {
                    String r = ROW_NAMES[y];
                    String f = String.format("wallpapers/%s_%s_%s", wallpaper.getFileName(), c, r);
                    e.map.func_94245_a("wallpaper:" + f);
                }
            }
        }
    }

    public static void onTextureStitchPost(TextureStitchEvent.Post e) {
        if (e.map.func_130086_a() != 0) {
            return;
        }
        spriteMap = new HashMap<WallpaperType, TextureAtlasSprite[]>();
        WallpaperType[] wallpapers = WallpaperType.values();
        for (int i = 0; i < wallpapers.length; ++i) {
            WallpaperType wallpaper = wallpapers[i];
            if (!wallpaper.isEnabled()) continue;
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[COLUMN_NAMES.length * ROW_NAMES.length];
            spriteMap.put(wallpaper, sprites);
            for (int x = 0; x < COLUMN_NAMES.length; ++x) {
                String c = COLUMN_NAMES[x];
                for (int y = 0; y < ROW_NAMES.length; ++y) {
                    TextureAtlasSprite sprite;
                    String r = ROW_NAMES[y];
                    String f = String.format("wallpapers/%s_%s_%s", wallpaper.getFileName(), c, r);
                    sprites[WallpaperData.combine((int)x, (int)y)] = sprite = e.map.func_110572_b(new ResourceLocation("wallpaper", f).toString());
                }
            }
        }
    }

    @Override
    public void initHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new WallpaperEventHandlerClient());
    }

    public static void removeWallpapers(World world, int x, int y, int z) {
        wallpaperManager.removeWallpapers(world, x, y, z);
        world.func_147458_c(x, y, z, x + 1, y + 1, z + 1);
    }

    public static void setWallpaper(World world, int x, int y, int z, EnumFacing face, WallpaperData wallpaper) {
        wallpaperManager.setWallpaper(world, x, y, z, face, wallpaper);
        world.func_147458_c(x, y, z, x + 1, y + 1, z + 1);
    }

    public static WallpaperData getWallpaper(World world, int x, int y, int z, EnumFacing face) {
        return wallpaperManager.getWallpaper(world, x, y, z, face);
    }

    public static WallpaperManager getWallpaperManager() {
        return wallpaperManager;
    }

    public static IIcon getSprite(WallpaperData wallpaperData) {
        TextureAtlasSprite[] sprites = spriteMap.get((Object)wallpaperData.getType());
        if (sprites == null) {
            return null;
        }
        return sprites[wallpaperData.getPart()];
    }

    public static IIcon getBlockIcon(Block block, IBlockAccess blockAccess, int x, int y, int z, int side) {
        WallpaperData wallpaper;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (wallpaper = wallpaperManager.getWallpaper((World)world, x, y, z, EnumFacingHelper.getEnumFacing(side))) != WallpaperData.NONE) {
            return ClientProxy.getSprite(wallpaper);
        }
        IIcon icon = block.func_149673_e((IBlockAccess)world, x, y, z, side);
        if (icon == null) {
            return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static void setupDiggingFXWallpaperData(World world, int x, int y, int z, int sideHit) {
        WallpaperData wallpaper = wallpaperManager.getWallpaper(world, x, y, z, EnumFacingHelper.getEnumFacing(sideHit));
        if (wallpaper != WallpaperData.NONE) {
            overrideEntityFXSprite.set(spriteMap.get((Object)wallpaper.getType())[wallpaper.getPart()]);
        }
    }

    public static IIcon getSprite(IIcon sprite) {
        if (overrideEntityFXSprite.get() == null) {
            return sprite;
        }
        return (IIcon)overrideEntityFXSprite.get();
    }

    public static void resetOverrideEntityFXSprite() {
        overrideEntityFXSprite.set(null);
    }

    public static boolean onPickBlock(MovingObjectPosition target, EntityPlayer player, World world) {
        int x;
        ItemStack result = null;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        Object te = null;
        if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            x = target.field_72311_b;
            int y = target.field_72312_c;
            int z = target.field_72309_d;
            Block block = world.func_147439_a(x, y, z);
            if (block.isAir((IBlockAccess)world, x, y, z)) {
                return false;
            }
            WallpaperData wallpaper = wallpaperManager.getWallpaper(world, x, y, z, EnumFacingHelper.getEnumFacing(target.field_72310_e));
            result = wallpaper == WallpaperData.NONE ? block.getPickBlock(target, world, x, y, z, player) : new ItemStack((Item)Wallpaper.itemWallpaper, 1, wallpaper.getType().ordinal());
        } else {
            if (target.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY || target.field_72308_g == null || !isCreative) {
                return false;
            }
            result = target.field_72308_g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x = 0; x < 9; ++x) {
            ItemStack stack = player.field_71071_by.func_70301_a(x);
            if (stack == null || !stack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)result)) continue;
            player.field_71071_by.field_70461_c = x;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.field_71071_by.func_70447_i();
        if (slot < 0 || slot >= 9) {
            slot = player.field_71071_by.field_70461_c;
        }
        player.field_71071_by.func_70299_a(slot, result);
        player.field_71071_by.field_70461_c = slot;
        return true;
    }

    static {
        overrideEntityFXSprite = new ThreadLocal();
    }
}

