/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.proxy;

import com.pau101.wallpaper.Wallpaper;
import com.pau101.wallpaper.gui.CreativeTabsWallpaper;
import com.pau101.wallpaper.item.ItemWallpaper;
import com.pau101.wallpaper.item.ItemWallpaperScraper;
import com.pau101.wallpaper.network.ProxyNetworkManager;
import com.pau101.wallpaper.network.play.client.C00ProxyPacketRequestChunkWallpapers;
import com.pau101.wallpaper.network.play.server.S01ProxyPacketWallpaperChange;
import com.pau101.wallpaper.network.play.server.S02ProxyPacketReturnChunkWallpapers;
import com.pau101.wallpaper.utils.IntKeyedHashMap;
import com.pau101.wallpaper.world.WallpaperBlockData;
import com.pau101.wallpaper.world.WallpaperData;
import com.pau101.wallpaper.world.WallpaperEventHandler;
import com.pau101.wallpaper.world.WallpaperManager;
import com.pau101.wallpaper.world.WallpaperType;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CommonProxy {
    private static WallpaperManager wallpaperManager = new WallpaperManager();

    public void initGUI() {
        Wallpaper.creativeTabsWallpaper = new CreativeTabsWallpaper();
    }

    public void initItems() {
        Wallpaper.itemWallpaper = new ItemWallpaper();
        GameRegistry.registerItem((Item)Wallpaper.itemWallpaper, (String)"wallpaper");
        Wallpaper.itemWallpaperScraper = new ItemWallpaperScraper();
        GameRegistry.registerItem((Item)Wallpaper.itemWallpaperScraper, (String)"wallpaper_scraper");
    }

    public void initCrafting() {
        WallpaperType[] wallpapers = WallpaperType.values();
        int amount = 12;
        Object[] recipe = new Object[]{"PA", "PB", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('A'), null, Character.valueOf('B'), null};
        for (int i = 0; i < wallpapers.length; ++i) {
            WallpaperType wallpaper = wallpapers[i];
            if (!wallpaper.isEnabled()) continue;
            recipe[5] = wallpaper.getColorOne().getName();
            recipe[7] = wallpaper.getColorTwo().getName();
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Wallpaper.itemWallpaper, amount, i), recipe));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Wallpaper.itemWallpaperScraper), new Object[]{"P", "I", "S", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood"}));
    }

    public void initHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new WallpaperEventHandler());
    }

    public void initNetwork() {
        Wallpaper.networkManager = new ProxyNetworkManager("wallpaper");
    }

    public static boolean validBlock(Block block) {
        return block.func_149688_o().func_76230_c() && block.func_149686_d() && !(block instanceof BlockLeaves);
    }

    public static void onBlockStateChange(World world, int x, int y, int z, Block block) {
        if (!CommonProxy.validBlock(block)) {
            CommonProxy.dropWallpapers(world, x, y, z);
            if (wallpaperManager.removeWallpapers(world, x, y, z)) {
                Chunk chunk = world.func_72938_d(x, z);
                S01ProxyPacketWallpaperChange pkt = new S01ProxyPacketWallpaperChange(x, y, z, WallpaperData.NONE, null);
                Wallpaper.networkManager.sendPacketToClientsWatchingChunk(chunk.field_76635_g, chunk.field_76647_h, world, pkt, new Entity[0]);
            }
        }
    }

    public static void onChunkUnload(Chunk chunk) {
        wallpaperManager.remove(chunk);
    }

    public static void onChunkDataSave(Chunk chunk, NBTTagCompound tagCompound) {
        if (wallpaperManager.containsChunk(chunk)) {
            IntKeyedHashMap<WallpaperBlockData> wallpapers = wallpaperManager.getWallpapers(chunk);
            NBTTagList wallpapersTagList = new NBTTagList();
            for (IntKeyedHashMap.Entry<WallpaperBlockData> entry : wallpapers.entrySet()) {
                int pos = entry.getKey();
                WallpaperBlockData data = entry.getValue();
                NBTTagCompound posTagCompound = new NBTTagCompound();
                posTagCompound.func_74768_a("x", WallpaperManager.getX(pos));
                posTagCompound.func_74768_a("y", WallpaperManager.getY(pos));
                posTagCompound.func_74768_a("z", WallpaperManager.getZ(pos));
                NBTTagCompound dataTagCompound = new NBTTagCompound();
                data.writeToNBT(dataTagCompound);
                NBTTagCompound wallpaperTagCompound = new NBTTagCompound();
                wallpaperTagCompound.func_74782_a("pos", (NBTBase)posTagCompound);
                wallpaperTagCompound.func_74782_a("data", (NBTBase)dataTagCompound);
                wallpapersTagList.func_74742_a((NBTBase)wallpaperTagCompound);
            }
            tagCompound.func_74782_a("wallpaper", (NBTBase)wallpapersTagList);
        }
    }

    public static void onChunkDataLoad(Chunk chunk, NBTTagCompound tagCompound) {
        IntKeyedHashMap<WallpaperBlockData> wallpapers = new IntKeyedHashMap<WallpaperBlockData>();
        NBTTagList wallpapersTagList = tagCompound.func_150295_c("wallpaper", 10);
        if (wallpapersTagList.func_74745_c() == 0) {
            return;
        }
        int length = wallpapersTagList.func_74745_c();
        for (int i = 0; i < length; ++i) {
            NBTTagCompound wallpaperTagCompound = wallpapersTagList.func_150305_b(i);
            NBTTagCompound posTagCompound = wallpaperTagCompound.func_74775_l("pos");
            int x = posTagCompound.func_74762_e("x");
            int y = posTagCompound.func_74762_e("y");
            int z = posTagCompound.func_74762_e("z");
            NBTTagCompound dataTagCompound = wallpaperTagCompound.func_74775_l("data");
            WallpaperBlockData data = WallpaperBlockData.readFromNBT(dataTagCompound);
            wallpapers.put(WallpaperManager.combineXYZ(x, y, z), data);
        }
        wallpaperManager.put(chunk, wallpapers);
    }

    public static void onRequestChunkWallpaper(C00ProxyPacketRequestChunkWallpapers pkt, INetHandler netHandler) {
        int xPosition = pkt.getXPosition();
        int zPosition = pkt.getZPosition();
        EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
        Chunk chunk = player.field_70170_p.func_72964_e(xPosition, zPosition);
        if (wallpaperManager.containsChunk(chunk)) {
            Wallpaper.networkManager.sendPacketToClient(new S02ProxyPacketReturnChunkWallpapers(xPosition, zPosition, wallpaperManager.getWallpapers(chunk)), player);
        }
    }

    public static void setWallpaper(World world, int x, int y, int z, EnumFacing face, WallpaperData wallpaper) {
        wallpaperManager.setWallpaper(world, x, y, z, face, wallpaper);
    }

    public static WallpaperData getWallpaper(World world, int x, int y, int z, EnumFacing face) {
        return wallpaperManager.getWallpaper(world, x, y, z, face);
    }

    public static WallpaperManager getWallpaperManager() {
        return wallpaperManager;
    }

    public static void dropWallpaper(World world, int x, int y, int z, EnumFacing face) {
        WallpaperData wallpaper = wallpaperManager.getWallpaper(world, x, y, z, face);
        if (wallpaper != WallpaperData.NONE) {
            ItemStack itemStack = new ItemStack((Item)Wallpaper.itemWallpaper, 1, wallpaper.getType().ordinal());
            CommonProxy.spawnAsEntity(world, x -= face.func_82601_c(), y -= face.func_96559_d(), z -= face.func_82599_e(), itemStack);
        }
    }

    private static void spawnAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            double radius = 0.5;
            double dx = (double)world.field_73012_v.nextFloat() * radius + (1.0 - radius) * 0.5;
            double dy = (double)world.field_73012_v.nextFloat() * radius + (1.0 - radius) * 0.5;
            double dz = (double)world.field_73012_v.nextFloat() * radius + (1.0 - radius) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack);
            entityItem.field_145804_b = 10;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static void dropWallpapers(World world, int x, int y, int z) {
        for (EnumFacing face : EnumFacing.values()) {
            CommonProxy.dropWallpaper(world, x, y, z, face);
        }
    }
}

