/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.utils;

import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntKeyedHashMap<T> {
    private Entry[] table = new Entry[16];
    private int size;
    private int threshold = 12;
    private float growFactor = 0.75f;
    private int modCount;
    private Set<Entry<T>> entrySet = null;
    private Set<Integer> keySet = null;

    private int hash(int k) {
        k ^= k >>> 20 ^ k >>> 12;
        return k ^ k >>> 7 ^ k >>> 4;
    }

    private int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T get(int key) {
        Entry entry = this.getEntry(key);
        return entry == null ? null : (T)entry.getValue();
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    private Entry getEntry(int key) {
        int hash = this.hash(key);
        Entry entry = this.table[this.indexFor(hash, this.table.length)];
        while (entry != null) {
            if (entry.key == key) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public T put(int key, T value) {
        int hash = this.hash(key);
        int i = this.indexFor(hash, this.table.length);
        Entry entry = this.table[i];
        while (entry != null) {
            if (entry.key == key) {
                Object oldValue = entry.value;
                entry.value = value;
                return (T)oldValue;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    private void addEntry(int hash, int key, T value, int i) {
        Entry entry = this.table[i];
        this.table[i] = new Entry<T>(hash, key, value, entry);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
        } else {
            Entry[] newTable = new Entry[newCapacity];
            this.transfer(newTable);
            this.table = newTable;
            this.threshold = (int)((float)newCapacity * this.growFactor);
        }
    }

    private void transfer(Entry[] newTable) {
        Entry[] oldTable = this.table;
        int newCapacity = newTable.length;
        for (int i = 0; i < oldTable.length; ++i) {
            Entry next;
            Entry e = oldTable[i];
            if (e == null) continue;
            oldTable[i] = null;
            do {
                next = e.next;
                int n = this.indexFor(e.hash, newCapacity);
                e.next = newTable[n];
                newTable[n] = e;
                e = next;
            } while (next != null);
        }
    }

    public T remove(int key) {
        Entry e = this.removeEntryForKey(key);
        return (T)(e == null ? null : e.value);
    }

    private Entry removeEntryForKey(int key) {
        Entry prev;
        int hash = this.hash(key);
        int i = this.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    private Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Entry)) {
            return null;
        }
        Entry entry = (Entry)o;
        int key = entry.getKey();
        int hash = this.hash(key);
        int i = this.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(T value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Set<Integer> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Set<Entry<T>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private Iterator<Integer> newKeyIterator() {
        return new KeyIterator();
    }

    private Iterator<Entry<T>> newEntryIterator() {
        return new EntryIterator();
    }

    public static class Entry<V> {
        private int hash;
        private int key;
        private V value;
        private Entry<V> next;

        public Entry(int hash, int key, V value, Entry<V> nextEntry) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = nextEntry;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            V entryValue;
            V thisValue;
            Integer entryHash;
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            Integer thisHash = this.getKey();
            return (thisHash == (entryHash = Integer.valueOf(entry.getKey())) || thisHash != null && thisHash.equals(entryHash)) && ((thisValue = this.getValue()) == (entryValue = entry.getValue()) || thisValue != null && thisValue.equals(entryValue));
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntryIterator
    extends HashIterator<Entry<T>> {
        private EntryIterator() {
        }

        @Override
        public Entry<T> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<Integer> {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<T> {
        private ValueIterator() {
        }

        @Override
        public T next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = IntKeyedHashMap.this.modCount;
            if (IntKeyedHashMap.this.size > 0) {
                Entry[] t = IntKeyedHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        protected Entry<T> nextEntry() {
            if (IntKeyedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = IntKeyedHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (IntKeyedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            IntKeyedHashMap.this.removeEntryForKey(k);
            this.expectedModCount = IntKeyedHashMap.this.modCount;
        }
    }

    private class EntrySet
    extends AbstractSet<Entry<T>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry<T>> iterator() {
            return IntKeyedHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = IntKeyedHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return IntKeyedHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return IntKeyedHashMap.this.size;
        }

        @Override
        public void clear() {
            IntKeyedHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return IntKeyedHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return IntKeyedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Integer ? IntKeyedHashMap.this.containsKey((Integer)o) : false;
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof Integer ? IntKeyedHashMap.this.removeEntryForKey((Integer)o) != null : false;
        }

        @Override
        public void clear() {
            IntKeyedHashMap.this.clear();
        }
    }
}

