/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.world;

import com.pau101.wallpaper.utils.MiscUtils;
import com.pau101.wallpaper.world.WallpaperData;
import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class WallpaperBlockData {
    private WallpaperData[] wallpapers = new WallpaperData[EnumFacing.values().length];

    public WallpaperBlockData() {
        Arrays.fill(this.wallpapers, WallpaperData.NONE);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.wallpapers);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WallpaperBlockData other = (WallpaperBlockData)obj;
        return Arrays.equals(this.wallpapers, other.wallpapers);
    }

    public String toString() {
        return "WallpaperBlockData [wallpapers=" + Arrays.toString(this.wallpapers) + "]";
    }

    public void setWallpaper(EnumFacing face, WallpaperData wallpaper) {
        this.setWallpaper(face.ordinal(), wallpaper);
    }

    public void setWallpaper(int face, WallpaperData wallpaper) {
        this.wallpapers[face] = wallpaper;
    }

    public void removeWallpaper(EnumFacing face) {
        this.wallpapers[face.ordinal()] = WallpaperData.NONE;
    }

    public WallpaperData getWallpaper(EnumFacing face) {
        return this.wallpapers[face.ordinal()];
    }

    public WallpaperData[] getWallpapers() {
        return this.wallpapers;
    }

    public int getWallpaperCount() {
        int count = 0;
        for (WallpaperData wallpaper : this.wallpapers) {
            if (wallpaper == WallpaperData.NONE) continue;
            ++count;
        }
        return count;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.wallpapers.length; ++i) {
            WallpaperData wallpaper = this.wallpapers[i];
            NBTTagCompound wallpaperTagCompound = new NBTTagCompound();
            wallpaper.writeToNBT(wallpaperTagCompound);
            tagList.func_74742_a((NBTBase)wallpaperTagCompound);
        }
        tagCompound.func_74782_a("wallpapers", (NBTBase)tagList);
    }

    public static WallpaperBlockData readFromNBT(NBTTagCompound tagCompound) {
        WallpaperBlockData wallpaperBlockData = new WallpaperBlockData();
        NBTTagList tagList = tagCompound.func_150295_c("wallpapers", 10);
        int size = tagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            wallpaperBlockData.setWallpaper(MiscUtils.safeEnumGet(EnumFacing.class, i), WallpaperData.readFromNBT(tagList.func_150305_b(i)));
        }
        return wallpaperBlockData;
    }
}

