/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.world;

import com.pau101.wallpaper.utils.MiscUtils;
import com.pau101.wallpaper.world.WallpaperType;
import net.minecraft.nbt.NBTTagCompound;

public class WallpaperData {
    public static final WallpaperData NONE = new WallpaperData(null, -1);
    private WallpaperType type;
    private int part;

    public WallpaperData(WallpaperType type, int part) {
        this.type = type;
        this.part = part;
    }

    public WallpaperData(WallpaperType type, int partX, int partY) {
        this(type, WallpaperData.combine(partX, partY));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.part;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WallpaperData other = (WallpaperData)obj;
        if (this.part != other.part) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "WallpaperData [type=" + (Object)((Object)this.type) + ", part=" + this.part + "]";
    }

    public WallpaperType getType() {
        return this.type;
    }

    public void setType(WallpaperType type) {
        this.type = type;
    }

    public int getPart() {
        return this.part;
    }

    public void setPart(int part) {
        this.part = part;
    }

    public int getPartX() {
        return WallpaperData.getPartX(this.part);
    }

    public int getPartY() {
        return WallpaperData.getPartY(this.part);
    }

    public static int getPartX(int part) {
        return part % 3;
    }

    public static int getPartY(int part) {
        return part / 3;
    }

    public static int combine(int partX, int partY) {
        partX = MiscUtils.wrap(partX, 3);
        partY = MiscUtils.wrap(partY, 4);
        return partY * 3 + partX;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("type", this.type == null ? "null" : this.type.name());
        tagCompound.func_74768_a("part", this.part);
    }

    public static WallpaperData readFromNBT(NBTTagCompound tagCompound) {
        int part;
        String typeString = tagCompound.func_74779_i("type");
        WallpaperType type = "null".equals(typeString) ? null : WallpaperType.valueOf(typeString);
        WallpaperData wallpaper = new WallpaperData(type, part = tagCompound.func_74762_e("part"));
        if (wallpaper.equals(NONE)) {
            wallpaper = NONE;
        }
        return wallpaper;
    }
}

