/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.wallpaper.world;

import com.pau101.wallpaper.utils.IntKeyedHashMap;
import com.pau101.wallpaper.world.WallpaperBlockData;
import com.pau101.wallpaper.world.WallpaperData;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;

public class WallpaperManager {
    public Map<Chunk, IntKeyedHashMap<WallpaperBlockData>> customData = new WeakHashMap<Chunk, IntKeyedHashMap<WallpaperBlockData>>();

    public void put(Chunk chunk, IntKeyedHashMap<WallpaperBlockData> wallpapers) {
        this.customData.put(chunk, wallpapers);
    }

    public void remove(Chunk chunk) {
        this.customData.remove(chunk);
    }

    public boolean containsChunk(Chunk chunk) {
        return this.customData.containsKey(chunk);
    }

    public IntKeyedHashMap<WallpaperBlockData> getWallpapers(Chunk chunk) {
        return this.customData.get(chunk);
    }

    public boolean removeWallpapers(World world, int x, int y, int z) {
        IntKeyedHashMap<WallpaperBlockData> wallpapers;
        int index = WallpaperManager.combineXYZ(x, y, z);
        Chunk chunk = world.func_72938_d(x, z);
        if (this.customData.containsKey(chunk) && (wallpapers = this.customData.get(chunk)).containsKey(index)) {
            wallpapers.remove(index);
            if (wallpapers.size() == 0) {
                this.customData.remove(chunk);
            }
            return true;
        }
        return false;
    }

    public void setWallpaper(World world, int x, int y, int z, EnumFacing face, WallpaperData wallpaper) {
        IntKeyedHashMap<Object> wallpapers;
        Chunk chunk = world.func_72938_d(x, z);
        if (this.customData.containsKey(chunk)) {
            wallpapers = this.customData.get(chunk);
        } else {
            wallpapers = new IntKeyedHashMap();
            this.customData.put(chunk, wallpapers);
        }
        int index = WallpaperManager.combineXYZ(x, y, z);
        WallpaperBlockData wallpaperBlockData = (WallpaperBlockData)wallpapers.get(index);
        if (wallpaperBlockData == null) {
            wallpaperBlockData = new WallpaperBlockData();
        }
        if (wallpaper == WallpaperData.NONE) {
            wallpaperBlockData.removeWallpaper(face);
            if (wallpaperBlockData.getWallpaperCount() == 0) {
                wallpapers.remove(index);
                if (wallpapers.size() == 0) {
                    this.customData.remove(chunk);
                }
            }
        } else {
            wallpaperBlockData.setWallpaper(face, wallpaper);
            wallpapers.put(index, wallpaperBlockData);
        }
    }

    public WallpaperBlockData getWallpaperBlockData(World world, int x, int y, int z) {
        int index = WallpaperManager.combineXYZ(x, y, z);
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk instanceof EmptyChunk) {
            return null;
        }
        if (this.customData.containsKey(chunk)) {
            IntKeyedHashMap<WallpaperBlockData> wallpapers = this.customData.get(chunk);
            return wallpapers.get(index);
        }
        return null;
    }

    public WallpaperData getWallpaper(World world, int x, int y, int z, EnumFacing face) {
        int index = WallpaperManager.combineXYZ(x, y, z);
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk instanceof EmptyChunk) {
            return WallpaperData.NONE;
        }
        if (this.customData.containsKey(chunk)) {
            IntKeyedHashMap<WallpaperBlockData> wallpapers = this.customData.get(chunk);
            WallpaperBlockData wallpaperBlockData = wallpapers.get(index);
            if (wallpaperBlockData == null) {
                return WallpaperData.NONE;
            }
            return wallpaperBlockData.getWallpapers()[face.ordinal()];
        }
        return WallpaperData.NONE;
    }

    public static int combineXYZ(int x, int y, int z) {
        return x % 16 + z % 16 * 16 + y * 256;
    }

    public static int getX(int index) {
        return index % 256 % 16;
    }

    public static int getY(int index) {
        return index / 256;
    }

    public static int getZ(int index) {
        return index % 256 / 16;
    }
}

