/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.handlers;

import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.util.Reflect;
import ru.turikhay.util.U;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static ExceptionHandler instance;
    private static long gcLastCall;

    public static ExceptionHandler getInstance() {
        if (instance == null) {
            instance = new ExceptionHandler();
        }
        return instance;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        OutOfMemoryError asOOM = Reflect.cast(e, OutOfMemoryError.class);
        if (asOOM == null || !ExceptionHandler.reduceMemory(asOOM)) {
            if (ExceptionHandler.scanTrace(e)) {
                try {
                    Alert.showError("Exception in thread " + t.getName(), e);
                }
                catch (Exception var5) {
                    var5.printStackTrace();
                }
            } else {
                U.log("Hidden exception in thread " + t.getName(), e);
            }
            TLauncher.sendLog(e);
        }
    }

    public static boolean reduceMemory(OutOfMemoryError e) {
        if (e == null) {
            return false;
        }
        U.log("OutOfMemory error has occurred, solving...");
        long currentTime = System.currentTimeMillis();
        long diff = Math.abs(currentTime - gcLastCall);
        if (diff > 5000L) {
            gcLastCall = currentTime;
            U.gc();
            return true;
        }
        U.log("GC is unable to reduce memory usage");
        return false;
    }

    private static boolean scanTrace(Throwable e) {
        StackTraceElement[] elements;
        StackTraceElement[] arr$ = elements = e.getStackTrace();
        int len$ = elements.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StackTraceElement element = arr$[i$];
            if (!element.getClassName().startsWith("ru.turikhay")) continue;
            return true;
        }
        return false;
    }
}

