/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.component.InterruptibleComponent;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.managers.ServerListManagerListener;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;

public class ServerListManager
extends InterruptibleComponent {
    private final Gson gson;
    private final Repository repository;
    private ServerList serverList;
    private final List<ServerListManagerListener> listeners;
    private static final String logPrefix = '[' + ServerListManager.class.getSimpleName() + ']';

    private ServerListManager(ComponentManager manager, Repository repository) throws Exception {
        super(manager);
        if (repository == null) {
            throw new NullPointerException("Repository cannot be NULL!");
        }
        this.repository = repository;
        this.gson = TLauncher.getGson();
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public ServerListManager(ComponentManager manager) throws Exception {
        this(manager, Repository.SERVERLIST_REPO);
    }

    public ServerList getList() {
        return this.serverList;
    }

    @Override
    protected boolean refresh(int refreshID) {
        this.refreshList[refreshID] = true;
        this.log("Refreshing servers...");
        for (ServerListManagerListener result : this.listeners) {
            result.onServersRefreshing(this);
        }
        Object lock1 = new Object();
        Time.start(lock1);
        ServerList result1 = null;
        Throwable e = null;
        try {
            result1 = this.loadFromList();
        }
        catch (Throwable var7) {
            e = var7;
        }
        if (this.isCancelled(refreshID)) {
            this.log("Server list refreshing has been cancelled (" + Time.stop(lock1) + " ms)");
            return false;
        }
        if (e != null) {
            for (ServerListManagerListener listener : this.listeners) {
                listener.onServersRefreshingFailed(this);
            }
            this.log("Cannot refresh servers (" + Time.stop(lock1) + " ms)", e);
            return true;
        }
        if (result1 != null) {
            this.serverList = result1;
        }
        this.log("Servers has been refreshed (" + Time.stop(lock1) + " ms)");
        this.log(this.serverList);
        this.refreshList[refreshID] = false;
        for (ServerListManagerListener listener : this.listeners) {
            listener.onServersRefreshed(this);
        }
        return true;
    }

    public static boolean reconstructList(ServerList promoted, File serversDat) throws IOException {
        if (promoted == null) {
            throw new NullPointerException("list");
        }
        if (serversDat == null) {
            throw new NullPointerException("servers.dat file");
        }
        ServerListManager.slog("Reconstructing...");
        ServerListManager.slog("Loading from file...");
        ServerList userList = ServerList.loadFromFile(serversDat);
        for (ServerList.Server promotedServer : promoted.getList()) {
            if (!userList.contains(promotedServer)) continue;
            userList.remove(promotedServer);
        }
        ServerList resultList1 = ServerList.sortLists(promoted, userList);
        resultList1.save(serversDat);
        return true;
    }

    public static void addFavoriteServer(ServerList.Server serv, File file) {
        ServerList serverList = new ServerList();
        serverList.add(serv);
        try {
            ServerListManager.reconstructList(serverList, file);
        }
        catch (Exception var4) {
            ServerListManager.slog("Couldn't reconstruct server list.", var4);
        }
    }

    private ServerList loadFromList() throws JsonSyntaxException, IOException {
        Object lock = new Object();
        Time.start(lock);
        ServerList list = this.gson.fromJson(this.repository.getUrl(), ServerList.class);
        this.log("Got in", Time.stop(lock), "ms");
        return list;
    }

    @Override
    protected void log(Object ... w) {
        U.log("[" + this.getClass().getSimpleName() + "]", w);
    }

    private static void slog(Object ... o) {
        U.log(logPrefix, o);
    }
}

