/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.images;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import ru.turikhay.tlauncher.exceptions.TLauncherException;
import ru.turikhay.tlauncher.ui.images.ImageIcon;

public class ImageCache {
    private static final boolean THROW_IF_ERROR = true;
    private static final Map<URL, BufferedImage> imageCache = Collections.synchronizedMap(new HashMap());

    public static BufferedImage loadImage(URL url, boolean throwIfError) {
        if (url == null) {
            throw new NullPointerException("URL is NULL");
        }
        try {
            BufferedImage e = ImageIO.read(url);
            imageCache.put(url, e);
            return e;
        }
        catch (Exception var3) {
            if (throwIfError) {
                throw new TLauncherException("Cannot load required image: " + url, var3);
            }
            var3.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadImage(URL url) {
        return ImageCache.loadImage(url, true);
    }

    public static BufferedImage getImage(String uri, boolean throwIfError) {
        return ImageCache.loadImage(ImageCache.getRes(uri), throwIfError);
    }

    public static BufferedImage getImage(String uri) {
        return ImageCache.getImage(uri, true);
    }

    public static ImageIcon getIcon(String uri, int width, int height, boolean throwIfError) {
        return new ImageIcon(ImageCache.getImage(uri, throwIfError), width, height);
    }

    public static ImageIcon getIcon(String uri, int width, int height) {
        return ImageCache.getIcon(uri, width, height, true);
    }

    public static ImageIcon getIcon(String uri, int widthNheight) {
        return ImageCache.getIcon(uri, widthNheight, widthNheight, true);
    }

    public static ImageIcon getIcon(String uri, boolean throwIfError) {
        return new ImageIcon(ImageCache.getImage(uri, throwIfError));
    }

    public static ImageIcon getIcon(String uri) {
        return ImageCache.getIcon(uri, 0, 0);
    }

    public static URL getRes(String uri) {
        return uri == null ? null : ImageCache.class.getResource(uri);
    }
}

