/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.menu;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Map;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.managers.ServerListManager;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.login.VersionComboBox;
import ru.turikhay.tlauncher.ui.menu.PopupMenuModel;
import ru.turikhay.tlauncher.ui.menu.PopupMenuView;
import ru.turikhay.util.U;
import ru.turikhay.util.statistics.ServerPopup;
import ru.turikhay.util.statistics.StatisticsCommand;
import ru.turikhay.util.statistics.StatisticsSending;
import ru.turikhay.util.statistics.StatisticsSendingWrapper;

public class PopupMenuController {
    private PopupMenuView menuView;
    private PopupMenuModel menuModel;
    private Component component;
    private boolean flag = false;
    private PopupMenuExit exit;

    public PopupMenuController(Component component, String address, String name, Map<String, Integer> map, String id) {
        this.menuModel = new PopupMenuModel(Localizable.get().get("menu.chooseVersion") + " " + name, Localizable.get().get("menu.version"), Localizable.get().get("menu.start"), Localizable.get().get("menu.copy"), map, address, Localizable.get().get("menu.favorite"), name, id);
        this.menuView = new PopupMenuView(this.menuModel, this);
        this.component = component;
        this.exit = new PopupMenuExit(this);
        if (component == TLauncher.getInstance().getFrame()) {
            this.menuView.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    TLauncher.getInstance().getFrame().mp.browser.addMouseListener(PopupMenuController.this.exit);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TLauncher.getInstance().getFrame().mp.browser.removeMouseListener(PopupMenuController.this.exit);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    public void show(int x, int y) {
        if (!this.flag) {
            this.menuModel.setSelectedIndex(TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.versions.getSelectedIndex());
            this.flag = true;
        }
        this.menuView.showPopup(x - 25, y - 10, this.component);
    }

    private void log(String line) {
        U.plog("[PaperMenuController] " + line);
    }

    public void hidePopupMenu() {
        if (this.menuView.isVisible()) {
            this.menuView.hidePopup();
        }
    }

    public void launchGame() {
        this.addFavorite(false);
        TLauncher.getInstance().getPopupMenuManager().unenablePopup();
        TLauncher.getInstance().getFrame().mp.openDefaultScene();
        ServerList.Server s = new ServerList.Server();
        s.setAddress(this.menuModel.getAddress());
        if (this.component == TLauncher.getInstance().getFrame()) {
            new StatisticsSendingWrapper(StatisticsCommand.TOP_SERVER, new ServerPopup(this.menuModel.getServerId())).startSending();
        } else {
            new StatisticsSending(StatisticsCommand.PAGE_SERVER, new ServerPopup(this.menuModel.getServerId())).start();
        }
        TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.startLauncher(s);
    }

    public void copyAddress() {
        StringSelection selection = new StringSelection(this.menuModel.getAddress());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
        Alert.showMessage("", Localizable.get().get("menu.copy.done"));
    }

    public void changeVersion(String actionCommand) {
        VersionComboBox versionComboBox = TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.versions;
        int index = this.menuModel.getHashMap().get(actionCommand);
        this.menuModel.setSelectedIndex(index);
        versionComboBox.setSelectedIndex(index);
    }

    public void addFavorite(boolean showMessage) {
        ServerList.Server serv = new ServerList.Server();
        serv.setAddress(this.menuModel.getAddress());
        serv.setName(serv.getIp());
        ServerListManager.addFavoriteServer(serv, new File(TLauncher.getInstance().getSettings().get("minecraft.gamedir"), "servers.dat"));
        if (showMessage) {
            Alert.showMessage("", Localizable.get().get("menu.favorite.done"));
        }
    }

    public boolean isVisible() {
        return this.menuView.isPopupVisible();
    }

    public String toString() {
        return "PopupMenuController [menuView=" + this.menuView + ", menuModel=" + this.menuModel + ", component=" + this.component + ", flag=" + this.flag + "]";
    }

    class PopupMenuExit
    extends MouseAdapter {
        private PopupMenuController controller;

        public PopupMenuExit(PopupMenuController controller) {
            this.controller = controller;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.controller.hidePopupMenu();
        }
    }
}

