/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import ru.turikhay.util.async.AsyncObjectGotErrorException;
import ru.turikhay.util.async.AsyncObjectNotReadyException;
import ru.turikhay.util.async.ExtendedThread;

public abstract class AsyncObject<E>
extends ExtendedThread {
    private boolean gotValue;
    private E value;
    private AsyncObjectGotErrorException error;

    protected AsyncObject() {
        super("AsyncObject");
    }

    @Override
    public void run() {
        try {
            this.value = this.execute();
        }
        catch (Throwable var2) {
            this.error = new AsyncObjectGotErrorException(this, var2);
            return;
        }
        this.gotValue = true;
    }

    public E getValue() throws AsyncObjectNotReadyException, AsyncObjectGotErrorException {
        if (this.error != null) {
            throw this.error;
        }
        if (!this.gotValue) {
            throw new AsyncObjectNotReadyException();
        }
        return this.value;
    }

    public AsyncObjectGotErrorException getError() {
        return this.error;
    }

    protected abstract E execute() throws AsyncObjectGotErrorException;
}

