/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.client.TextBlockClient;
import org.lwjgl.opengl.GL11;

public class ChatMessages {
    private static Map<String, ChatMessages> users = new Hashtable<String, ChatMessages>();
    private Map<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
    private int boxLength = 46;
    private float scale = 0.5f;
    private String lastMessage = "";
    private long lastMessageTime = 0L;
    private static Pattern[] patterns = new Pattern[]{Pattern.compile("^<+([a-zA-z0-9_]{2,16})>[:]? (.*)"), Pattern.compile("^\\[.*[\\]]{1,16}[^a-zA-z0-9]?([a-zA-z0-9_]{2,16})[:]? (.*)"), Pattern.compile("^[a-zA-z0-9_]{2,10}[^a-zA-z0-9]([a-zA-z0-9_]{2,16})[:]? (.*)")};

    public void addMessage(String message) {
        if (!MorePlayerModels.EnableChatBubbles) {
            return;
        }
        long time = System.currentTimeMillis();
        if (message.equals(this.lastMessage) && this.lastMessageTime + 1000L > time) {
            return;
        }
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>(this.messages);
        messages.put(time, new TextBlockClient(message, this.boxLength * 4));
        if (messages.size() > 3) {
            messages.remove(messages.keySet().iterator().next());
        }
        this.messages = messages;
        this.lastMessage = message;
        this.lastMessageTime = time;
    }

    public void renderMessages(double par3, double par5, double par7, boolean inRange) {
        Map<Long, TextBlockClient> messages = this.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        if (inRange) {
            this.render(par3, par5, par7, false);
        }
        this.render(par3, par5, par7, true);
    }

    public void render(double par3, double par5, double par7, boolean depth) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        GlStateManager.func_179094_E();
        int size = 0;
        for (TextBlockClient block : this.messages.values()) {
            size += block.lines.size();
        }
        Minecraft mc = Minecraft.func_71410_x();
        int textYSize = (int)((float)(size * font.field_78288_b) * this.scale);
        GlStateManager.func_179109_b((float)((float)par3 + 0.0f), (float)((float)par5 + (float)textYSize * var14), (float)((float)par7));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-var14), (float)(-var14), (float)var14);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        if (depth) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        int black = depth ? -16777216 : 0x55000000;
        int white = depth ? -1140850689 : 0x44FFFFFF;
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        ChatMessages.drawRect(-this.boxLength - 2, -2, this.boxLength + 2, textYSize + 1, white, 0.11);
        ChatMessages.drawRect(-this.boxLength - 1, -3, this.boxLength + 1, -2, black, 0.1);
        ChatMessages.drawRect(-this.boxLength - 1, textYSize + 2, -1, textYSize + 1, black, 0.1);
        ChatMessages.drawRect(3, textYSize + 2, this.boxLength + 1, textYSize + 1, black, 0.1);
        ChatMessages.drawRect(-this.boxLength - 3, -1, -this.boxLength - 2, textYSize, black, 0.1);
        ChatMessages.drawRect(this.boxLength + 3, -1, this.boxLength + 2, textYSize, black, 0.1);
        ChatMessages.drawRect(-this.boxLength - 2, -2, -this.boxLength - 1, -1, black, 0.1);
        ChatMessages.drawRect(this.boxLength + 2, -2, this.boxLength + 1, -1, black, 0.1);
        ChatMessages.drawRect(-this.boxLength - 2, textYSize + 1, -this.boxLength - 1, textYSize, black, 0.1);
        ChatMessages.drawRect(this.boxLength + 2, textYSize + 1, this.boxLength + 1, textYSize, black, 0.1);
        ChatMessages.drawRect(0, textYSize + 1, 3, textYSize + 4, white, 0.11);
        ChatMessages.drawRect(-1, textYSize + 4, 1, textYSize + 5, white, 0.11);
        ChatMessages.drawRect(-1, textYSize + 1, 0, textYSize + 4, black, 0.1);
        ChatMessages.drawRect(3, textYSize + 1, 4, textYSize + 3, black, 0.1);
        ChatMessages.drawRect(2, textYSize + 3, 3, textYSize + 4, black, 0.1);
        ChatMessages.drawRect(1, textYSize + 4, 2, textYSize + 5, black, 0.1);
        ChatMessages.drawRect(-2, textYSize + 4, -1, textYSize + 5, black, 0.1);
        ChatMessages.drawRect(-2, textYSize + 5, 1, textYSize + 6, black, 0.1);
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        int index = 0;
        for (TextBlockClient block : this.messages.values()) {
            for (ITextComponent chat : block.lines) {
                String message = chat.func_150254_d();
                font.func_78276_b(message, -font.func_78256_a(message) / 2, index * font.field_78288_b, black);
                ++index;
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void drawRect(int par0, int par1, int par2, int par3, int par4, double par5) {
        int j1;
        if (par0 < par2) {
            j1 = par0;
            par0 = par2;
            par2 = j1;
        }
        if (par1 < par3) {
            j1 = par1;
            par1 = par3;
            par3 = j1;
        }
        float f = (float)(par4 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par4 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par4 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par4 & 0xFF) / 255.0f;
        VertexBuffer tessellator = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179131_c((float)f1, (float)f2, (float)f3, (float)f);
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tessellator.func_181662_b((double)par0, (double)par3, par5).func_181675_d();
        tessellator.func_181662_b((double)par2, (double)par3, par5).func_181675_d();
        tessellator.func_181662_b((double)par2, (double)par1, par5).func_181675_d();
        tessellator.func_181662_b((double)par0, (double)par1, par5).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static ChatMessages getChatMessages(String username) {
        if (users.containsKey(username)) {
            return users.get(username);
        }
        ChatMessages chat = new ChatMessages();
        users.put(username, chat);
        return chat;
    }

    public static void parseMessage(String toParse) {
        toParse = toParse.replaceAll("\u00a7.", "");
        for (Pattern pattern : patterns) {
            String username;
            Matcher m = pattern.matcher(toParse);
            if (!m.find() || !ChatMessages.validPlayer(username = m.group(1))) continue;
            String message = m.group(2);
            ChatMessages.getChatMessages(username).addMessage(message);
            return;
        }
    }

    public static void test() {
        ChatMessages.test("<Sirnoppes01> :)", "Sirnoppes01: :)");
        ChatMessages.test("<Sirnoppes01> hey", "Sirnoppes01: hey");
        ChatMessages.test("<Sir_noppes> hey", "Sir_noppes: hey");
        ChatMessages.test("<Sirnoppes>: hey", "Sirnoppes: hey");
        ChatMessages.test("[member]Sirnoppes: hey", "Sirnoppes: hey");
        ChatMessages.test("[member]Sirnoppes01: hey", "Sirnoppes01: hey");
        ChatMessages.test("[member]Sir_noppes: hey", "Sir_noppes: hey");
        ChatMessages.test("[member] Sirnoppes: hey", "Sirnoppes: hey");
        ChatMessages.test("[g][member]Sirnoppes: hey", "Sirnoppes: hey");
        ChatMessages.test("[g] [member]Sirnoppes: hey", "Sirnoppes: hey");
        ChatMessages.test("[g] [member]-Sirnoppes: hey", "Sirnoppes: hey");
        ChatMessages.test("[Player755: Teleported Player755 to Player885]", "");
        ChatMessages.test("member Sirnoppes: hey", "Sirnoppes: hey");
        ChatMessages.test("member-Sirnoppes: hey", "Sirnoppes: hey");
        ChatMessages.test("member: Sirnoppes: hey", "");
    }

    private static void test(String toParse, String result) {
        for (Pattern pattern : patterns) {
            Matcher m = pattern.matcher(toParse);
            if (!m.find()) continue;
            String username = m.group(1);
            String message = m.group(2);
            if (message == null || username == null) continue;
            if (result.isEmpty()) {
                System.err.println("failed: " + toParse + " - " + username + ": " + message);
                return;
            }
            if (!(username + ": " + message).equals(result)) continue;
            System.out.println("succes: " + toParse);
            return;
        }
        if (result.isEmpty()) {
            System.out.println("succes: " + toParse);
        } else {
            System.err.println("failed: " + toParse);
        }
    }

    private static boolean validPlayer(String username) {
        return Minecraft.func_71410_x().field_71441_e.func_72924_a(username) != null;
    }

    private Map<Long, TextBlockClient> getMessages() {
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
        long time = System.currentTimeMillis();
        for (Map.Entry<Long, TextBlockClient> entry : this.messages.entrySet()) {
            if (time > entry.getKey() + 10000L) continue;
            messages.put(entry.getKey(), entry.getValue());
        }
        this.messages = messages;
        return this.messages;
    }

    public boolean hasMessage() {
        return !this.messages.isEmpty();
    }
}

