/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import noppes.mpm.ModelData;
import noppes.mpm.ModelPartData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.ServerTickHandler;
import noppes.mpm.client.Client;
import noppes.mpm.client.ClientProxy;
import noppes.mpm.client.RenderEvent;
import noppes.mpm.client.fx.EntityEnderFX;
import noppes.mpm.client.fx.EntityRainbowFX;
import noppes.mpm.client.gui.GuiCreationScreenInterface;
import noppes.mpm.client.gui.GuiMPM;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;
import noppes.mpm.constants.EnumParts;
import noppes.mpm.util.MPMEntityUtil;

public class ClientEventHandler {
    public static float partialTicks = 0.0f;
    private World prevWorld;
    private List<EntityPlayer> playerlist;

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        if (ClientProxy.Screen.func_151468_f()) {
            ModelData data = ModelData.get((EntityPlayer)mc.field_71439_g);
            data.setAnimation(EnumAnimation.NONE);
            if (mc.field_71462_r == null) {
                mc.func_147108_a((GuiScreen)new GuiMPM());
            }
        }
        if (!mc.field_71415_G) {
            return;
        }
        if (ClientProxy.Sleep.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button1);
        }
        if (ClientProxy.Sit.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button2);
        }
        if (ClientProxy.Dance.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button3);
        }
        if (ClientProxy.Hug.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button4);
        }
        if (ClientProxy.Crawl.func_151468_f()) {
            this.processAnimation(MorePlayerModels.button5);
        }
    }

    private void processAnimation(int type) {
        if (type <= 0) {
            return;
        }
        if (MorePlayerModels.HasServerSide) {
            Client.sendData(EnumPackets.ANIMATION, type);
        } else {
            ModelData data;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            EnumAnimation animation = EnumAnimation.values()[type];
            if (animation == EnumAnimation.SLEEPING_SOUTH) {
                float rotation;
                for (rotation = player.field_70177_z; rotation < 0.0f; rotation += 360.0f) {
                }
                while (rotation > 360.0f) {
                    rotation -= 360.0f;
                }
                int rotate = (int)((rotation + 45.0f) / 90.0f);
                if (rotate == 1) {
                    animation = EnumAnimation.SLEEPING_WEST;
                }
                if (rotate == 2) {
                    animation = EnumAnimation.SLEEPING_NORTH;
                }
                if (rotate == 3) {
                    animation = EnumAnimation.SLEEPING_EAST;
                }
            }
            if ((data = ModelData.get((EntityPlayer)player)).animationEquals(animation)) {
                animation = EnumAnimation.NONE;
            }
            data.setAnimation(animation.ordinal());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        partialTicks = event.renderTickTime;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && this.prevWorld != mc.field_71441_e) {
            MorePlayerModels.HasServerSide = false;
            GuiCreationScreenInterface.Message = "message.noserver";
            ModelData data = ModelData.get((EntityPlayer)mc.field_71439_g);
            Client.sendData(EnumPackets.PING, MorePlayerModels.Version, data.writeToNBT());
            this.prevWorld = mc.field_71441_e;
            ClientProxy.FixModels(false);
        }
        ++RenderEvent.lastSkinTick;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        ModelData data = ModelData.get(player);
        EntityLivingBase entity = data.getEntity(player);
        if (entity != null) {
            entity.func_70071_h_();
            MPMEntityUtil.Copy((EntityLivingBase)player, entity);
        }
        if (data.inLove > 0) {
            --data.inLove;
            if (player.func_70681_au().nextBoolean()) {
                double d0 = player.func_70681_au().nextGaussian() * 0.02;
                double d1 = player.func_70681_au().nextGaussian() * 0.02;
                double d2 = player.func_70681_au().nextGaussian() * 0.02;
                player.field_70170_p.func_175688_a(EnumParticleTypes.HEART, player.field_70165_t + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, player.field_70163_u + 0.5 + (double)(player.func_70681_au().nextFloat() * player.field_70131_O), player.field_70161_v + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        if (data.animation == EnumAnimation.CRY) {
            float f1 = player.field_70177_z * (float)Math.PI / 180.0f;
            float dx = -MathHelper.func_76126_a((float)f1);
            float dz = MathHelper.func_76134_b((float)f1);
            int i = 0;
            while ((float)i < 10.0f) {
                float f2 = (player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 0.5f + dx * 0.15f;
                float f3 = (player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 0.5f + dz * 0.15f;
                player.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, player.field_70165_t + (double)f2, player.field_70163_u - (double)data.getBodyY() + (double)1.1f - player.func_70033_W(), player.field_70161_v + (double)f3, (double)1.0E-25f, 0.0, (double)1.0E-25f, new int[0]);
                ++i;
            }
        }
        if (data.animation != EnumAnimation.NONE) {
            ServerTickHandler.checkAnimation(player, data);
        }
        data.prevPosX = player.field_70165_t;
        data.prevPosY = player.field_70163_u;
        data.prevPosZ = player.field_70161_v;
        ModelPartData particles = data.getPartData(EnumParts.PARTICLES);
        if (particles != null) {
            this.spawnParticles(player, data, particles);
        }
    }

    private void spawnParticles(EntityPlayer player, ModelData data, ModelPartData particles) {
        block4: {
            Random rand;
            double height;
            Minecraft minecraft;
            block3: {
                if (!MorePlayerModels.EnableParticles) {
                    return;
                }
                minecraft = Minecraft.func_71410_x();
                height = player.func_70033_W() + (double)data.getBodyY();
                rand = player.func_70681_au();
                if (particles.type != 0) break block3;
                for (int i = 0; i < 2; ++i) {
                    EntityEnderFX fx = new EntityEnderFX((AbstractClientPlayer)player, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, rand.nextDouble() * (double)player.field_70131_O - height - 0.25, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, particles);
                    minecraft.field_71452_i.func_78873_a((Particle)fx);
                }
                break block4;
            }
            if (particles.type != 1) break block4;
            for (int i = 0; i < 2; ++i) {
                double x = player.field_70165_t + (rand.nextDouble() - 0.5) * 0.9;
                double y = player.field_70163_u + rand.nextDouble() * 1.9 - 0.25 - height;
                double z = player.field_70161_v + (rand.nextDouble() - 0.5) * 0.9;
                double f = (rand.nextDouble() - 0.5) * 2.0;
                double f1 = -rand.nextDouble();
                double f2 = (rand.nextDouble() - 0.5) * 2.0;
                minecraft.field_71452_i.func_78873_a((Particle)new EntityRainbowFX(player.field_70170_p, x, y, z, f, f1, f2));
            }
        }
    }
}

