/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.entity.MPMRenderEntityUtil;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noppes.mpm.LogWriter;
import noppes.mpm.ModelData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.client.ChatMessages;
import noppes.mpm.client.ClientEventHandler;
import noppes.mpm.client.ImageBufferDownloadAlt;
import noppes.mpm.client.ImageDownloadAlt;
import noppes.mpm.client.layer.LayerPreRender;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.util.PixelmonHelper;

public class RenderEvent {
    public static RenderEvent Instance;
    public EntityRenderer orignalRenderer;
    public static long lastSkinTick;
    public static final int MaxUrlTicks = 6;
    private static ResourceLocation skinResource;
    private static ITextureObject textureObject;

    public RenderEvent() {
        Instance = this;
        Minecraft mc = Minecraft.func_71410_x();
        this.orignalRenderer = mc.field_71460_t;
    }

    @SubscribeEvent
    public void post(RenderLivingEvent.Post event) {
        if (textureObject != null) {
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            texturemanager.func_110579_a(skinResource, textureObject);
            skinResource = null;
            textureObject = null;
        }
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        ModelData data = ModelData.get((EntityPlayer)player);
        if (data.isSleeping()) {
            player.field_70761_aq = player.field_70760_ar = player.field_70177_z;
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void pre(RenderLivingEvent.Pre event) {
        EntityLivingBase entity;
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        GlStateManager.func_179094_E();
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        ModelData data = ModelData.get((EntityPlayer)player);
        if (data.isSleeping()) {
            if (data.animation == EnumAnimation.SLEEPING_EAST) {
                player.field_70760_ar = -90.0f;
                player.field_70761_aq = -90.0f;
            }
            if (data.animation == EnumAnimation.SLEEPING_WEST) {
                player.field_70760_ar = 90.0f;
                player.field_70761_aq = 90.0f;
            }
            if (data.animation == EnumAnimation.SLEEPING_NORTH) {
                player.field_70760_ar = 180.0f;
                player.field_70761_aq = 180.0f;
            }
            if (data.animation == EnumAnimation.SLEEPING_SOUTH) {
                player.field_70760_ar = 0.0f;
                player.field_70761_aq = 0.0f;
            }
        }
        float offset = data.getOffsetCamera((EntityPlayer)player);
        player.eyeHeight = player.getDefaultEyeHeight() - offset;
        if (!data.loaded && lastSkinTick > 6L) {
            this.loadPlayerResource((EntityPlayer)player, data);
            lastSkinTick = 0L;
            data.loaded = true;
        }
        if ((entity = data.getEntity((EntityPlayer)player)) != null) {
            event.setCanceled(true);
            if (PixelmonHelper.isPixelmon((Entity)entity)) {
                entity.func_70095_a(true);
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (data.textureObject != null) {
                skinResource = MPMRenderEntityUtil.getResource((Entity)entity);
                TextureManager texturemanager = mc.func_110434_K();
                textureObject = texturemanager.func_110581_b(skinResource);
                if (textureObject == null) {
                    skinResource = null;
                } else {
                    texturemanager.func_110579_a(skinResource, (ITextureObject)data.textureObject);
                }
            }
            mc.func_175598_ae().func_188388_a((Entity)entity, ClientEventHandler.partialTicks, false);
            GlStateManager.func_179121_F();
            return;
        }
        offset = 0.0f;
        if (player.field_71075_bZ.field_75100_b && player.field_70170_p.func_175623_d(player.func_180425_c())) {
            offset = MathHelper.func_76134_b((float)((float)player.field_70173_aa * 0.1f)) * -0.06f;
        }
        if (data.animation == EnumAnimation.SITTING) {
            offset = (float)((double)offset + (0.5 - (double)data.getLegsY() * 0.8));
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-offset), (float)0.0f);
        List layers = event.getRenderer().field_177097_h;
        for (LayerRenderer layer : layers) {
            if (!(layer instanceof LayerPreRender)) continue;
            ((LayerPreRender)layer).preRender(player);
        }
    }

    public void loadPlayerResource(EntityPlayer pl, ModelData data) {
        Minecraft minecraft = Minecraft.func_71410_x();
        data.textureObject = null;
        AbstractClientPlayer player = (AbstractClientPlayer)pl;
        if (data.url != null && !data.url.isEmpty()) {
            if (!data.url.startsWith("http://") && !data.url.startsWith("https://")) {
                ResourceLocation location = new ResourceLocation(data.url);
                try {
                    minecraft.func_110434_K().func_110577_a(location);
                    data.textureObject = minecraft.func_110434_K().func_110581_b(location);
                }
                catch (Exception e) {
                    location = DefaultPlayerSkin.func_177335_a();
                }
                this.setPlayerTexture(player, location);
            } else {
                ResourceLocation location = new ResourceLocation("skins/" + data.url.hashCode());
                if (!player.func_152122_n()) {
                    location = player.func_110306_p();
                } else {
                    this.setPlayerTexture(player, location);
                }
                data.textureObject = this.loadTexture(null, location, DefaultPlayerSkin.func_177335_a(), data.url, false);
            }
            return;
        }
        if (!data.playerLoaded) {
            Map map = minecraft.func_152342_ad().func_152788_a(pl.func_146103_bH());
            if (map.isEmpty()) {
                map = minecraft.func_152347_ac().getTextures(minecraft.func_152347_ac().fillProfileProperties(player.func_146103_bH(), false), false);
            }
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                MinecraftProfileTexture profile = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                File dir = new File((File)ObfuscationReflectionHelper.getPrivateValue(SkinManager.class, (Object)minecraft.func_152342_ad(), (int)2), profile.getHash().substring(0, 2));
                File file = new File(dir, profile.getHash());
                if (file.exists()) {
                    file.delete();
                }
                ResourceLocation location = new ResourceLocation("skins/" + profile.getHash());
                this.loadTexture(file, location, DefaultPlayerSkin.func_177335_a(), profile.getUrl(), true);
                this.setPlayerTexture(player, location);
                data.playerLoaded = true;
                return;
            }
        }
        this.setPlayerTexture(player, null);
    }

    private void setPlayerTexture(AbstractClientPlayer player, ResourceLocation texture) {
        NetworkPlayerInfo playerInfo = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)player, (int)0);
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = (Map)ObfuscationReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (int)1);
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            ObfuscationReflectionHelper.setPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (Object)false, (int)4);
        }
    }

    private ITextureObject loadTexture(File file, ResourceLocation resource, ResourceLocation def, String par1Str, boolean fix64) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ImageDownloadAlt object = new ImageDownloadAlt(file, par1Str, def, (IImageBuffer)new ImageBufferDownloadAlt(fix64));
        texturemanager.func_110579_a(resource, (ITextureObject)object);
        return object;
    }

    @SubscribeEvent
    public void hand(RenderHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ModelData data = ModelData.get((EntityPlayer)mc.field_71439_g);
        mc.field_71439_g.eyeHeight = mc.field_71439_g.getDefaultEyeHeight() - data.getOffsetCamera((EntityPlayer)mc.field_71439_g);
        EntityLivingBase entity = data.getEntity((EntityPlayer)mc.field_71439_g);
        if (entity != null || data.isSleeping() || data.animation == EnumAnimation.CRAWLING || data.animation == EnumAnimation.BOW && mc.field_71439_g.func_184614_ca() == null) {
            event.setCanceled(true);
            return;
        }
        if (!data.loaded && lastSkinTick > 6L) {
            this.loadPlayerResource((EntityPlayer)mc.field_71439_g, data);
            lastSkinTick = 0L;
            data.loaded = true;
        }
    }

    @SubscribeEvent
    public void chat(ClientChatReceivedEvent event) {
        if (MorePlayerModels.HasServerSide) {
            return;
        }
        try {
            ChatMessages.parseMessage(event.getMessage().func_150254_d());
        }
        catch (Exception ex) {
            LogWriter.warn("Cant handle chatmessage: " + event.getMessage() + ":" + ex.getMessage());
        }
    }

    @SubscribeEvent
    public void selectionBox(DrawBlockHighlightEvent event) {
        if (MorePlayerModels.HideSelectionBox) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void overlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null || MorePlayerModels.Tooltips == 0) {
            return;
        }
        ItemStack item = mc.field_71439_g.func_184614_ca();
        if (item == null) {
            return;
        }
        String name = item.func_82833_r();
        int x = event.getResolution().func_78326_a() - mc.field_71466_p.func_78256_a(name);
        int posX = 4;
        int posY = 4;
        if (MorePlayerModels.Tooltips % 2 == 0) {
            posX = x - 4;
        }
        if (MorePlayerModels.Tooltips > 2) {
            posY = event.getResolution().func_78328_b() - 24;
        }
        mc.field_71466_p.func_175063_a(name, (float)posX, (float)posY, 0xFFFFFF);
        if (item.func_77984_f()) {
            int max = item.func_77958_k();
            String dam = max - item.func_77952_i() + "/" + max;
            x = event.getResolution().func_78326_a() - mc.field_71466_p.func_78256_a(dam);
            if (MorePlayerModels.Tooltips == 2 || MorePlayerModels.Tooltips == 4) {
                posX = x - 4;
            }
            mc.field_71466_p.func_175063_a(dam, (float)posX, (float)(posY + 12), 0xFFFFFF);
        }
    }

    static {
        lastSkinTick = 0L;
        skinResource = null;
        textureObject = null;
    }
}

