/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import joptsimple.OptionSet;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.configuration.ArgumentParser;
import ru.turikhay.tlauncher.configuration.ConfigurationDefaults;
import ru.turikhay.tlauncher.configuration.PlainParser;
import ru.turikhay.tlauncher.configuration.SimpleConfiguration;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncher;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.Direction;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.Reflect;
import ru.turikhay.util.U;

public class Configuration
extends SimpleConfiguration {
    private ConfigurationDefaults defaults;
    private Map<String, Object> constants;
    private List<Locale> defaultLocales;
    private List<Locale> supportedLocales;
    private boolean firstRun;

    private Configuration(URL url, OptionSet set) throws IOException {
        super(url);
        this.init(set);
    }

    private Configuration(File file, OptionSet set) {
        super(file);
        this.init(set);
    }

    public static Configuration createConfiguration(OptionSet set) throws IOException {
        boolean doesntExist;
        File file;
        Object path;
        Object object = path = set != null ? set.valueOf("settings") : null;
        if (path == null) {
            file = FileUtil.getNeighborFile("tlauncher.cfg");
            if (!file.isFile()) {
                file = FileUtil.getNeighborFile("tlauncher.properties");
            }
            if (!file.isFile()) {
                file = MinecraftUtil.getSystemRelatedDirectory(TLauncher.getSettingsFile());
            }
        } else {
            file = new File(path.toString());
        }
        boolean bl = doesntExist = !file.isFile();
        if (doesntExist) {
            U.log("Creating configuration file...");
            FileUtil.createFile(file);
        }
        U.log("Loading configuration from file:", file);
        Configuration config = new Configuration(file, set);
        config.firstRun = doesntExist;
        return config;
    }

    public static Configuration createConfiguration() throws IOException {
        return Configuration.createConfiguration(null);
    }

    private void init(OptionSet set) {
        this.comments = " TLauncher configuration file\n Created in " + TLauncher.getBrand() + " " + TLauncher.getVersion();
        this.defaults = new ConfigurationDefaults();
        this.constants = ArgumentParser.parse(set);
        this.set(this.constants, false);
        this.log("Constant values:", this.constants);
        int version = ConfigurationDefaults.getVersion();
        if (this.getDouble("settings.version") != (double)version) {
            this.clear();
        }
        this.set("settings.version", version, false);
        for (Map.Entry<String, Object> chooser : this.defaults.getMap().entrySet()) {
            String e = chooser.getKey();
            if (this.constants.containsKey(e)) {
                this.log("Key \"" + e + "\" is unsaveable!");
                continue;
            }
            String value = this.get(e);
            Object defvalue = chooser.getValue();
            if (defvalue == null) continue;
            try {
                PlainParser.parse(value, defvalue);
            }
            catch (Exception var10) {
                this.log("Key \"" + e + "\" is invalid!", var10);
                this.set(e, defvalue, false);
            }
        }
        this.defaultLocales = Configuration.getDefaultLocales();
        this.supportedLocales = this.getSupportedLocales();
        Locale selected1 = Configuration.getLocaleOf(this.get("locale"));
        if (selected1 == null) {
            this.log("Selected locale is not supported, rolling back to default one");
            selected1 = Locale.getDefault();
            if (selected1 == Configuration.getLocaleOf("uk_UA")) {
                selected1 = Configuration.getLocaleOf("ru_RU");
            }
        }
        if (!this.supportedLocales.contains(selected1)) {
            this.log("Default locale is not supported, rolling back to global default one");
            selected1 = Locale.US;
        }
        this.set("locale", selected1, false);
        String chooser1 = this.get("chooser.type.account");
        if (chooser1 == null) {
            this.set("chooser.type.account", false, false);
        }
        if (this.isSaveable()) {
            try {
                this.save();
            }
            catch (IOException var9) {
                this.log("Cannot save value!", var9);
            }
        }
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public boolean isSaveable(String key) {
        return !this.constants.containsKey(key);
    }

    public Locale getLocale() {
        return Configuration.getLocaleOf(this.get("locale"));
    }

    public boolean isUSSRLocale() {
        String locale = this.get("locale");
        return "ru_RU".equals(locale) || "uk_UA".equals(locale);
    }

    public Locale[] getLocales() {
        Locale[] locales = new Locale[this.supportedLocales.size()];
        return this.supportedLocales.toArray(locales);
    }

    public ActionOnLaunch getActionOnLaunch() {
        return ActionOnLaunch.get(this.get("minecraft.onlaunch"));
    }

    public ConsoleType getConsoleType() {
        return ConsoleType.get(this.get("gui.console"));
    }

    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.get(this.get("connection"));
    }

    public int[] getClientWindowSize() {
        String plainValue = this.get("minecraft.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray ignored = IntegerArray.parseIntegerArray(plainValue);
            value[0] = ignored.get(0);
            value[1] = ignored.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getLauncherWindowSize() {
        String plainValue = this.get("gui.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray ignored = IntegerArray.parseIntegerArray(plainValue);
            value[0] = ignored.get(0);
            value[1] = ignored.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getDefaultClientWindowSize() {
        String plainValue = this.getDefault("minecraft.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public int[] getDefaultLauncherWindowSize() {
        String plainValue = this.getDefault("gui.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public VersionFilter getVersionFilter() {
        VersionFilter filter = new VersionFilter();
        for (ReleaseType len$ : ReleaseType.getDefinable()) {
            boolean i$ = this.getBoolean("minecraft.versions." + (Object)((Object)len$));
            if (i$) continue;
            filter.exclude(len$);
        }
        for (ReleaseType.SubType type : ReleaseType.SubType.values()) {
            boolean include = this.getBoolean("minecraft.versions.sub." + (Object)((Object)type));
            if (include) continue;
            filter.exclude(type);
        }
        return filter;
    }

    public Direction getDirection(String key) {
        return Reflect.parseEnum(Direction.class, this.get(key));
    }

    public Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public UUID getClient() {
        try {
            return UUID.fromString(this.get("client"));
        }
        catch (Exception var2) {
            return null;
        }
    }

    @Override
    public String getDefault(String key) {
        return this.getStringOf(this.defaults.get(key));
    }

    @Override
    public int getDefaultInteger(String key) {
        return this.getIntegerOf(this.defaults.get(key), 0);
    }

    @Override
    public double getDefaultDouble(String key) {
        return this.getDoubleOf(this.defaults.get(key), 0.0);
    }

    @Override
    public float getDefaultFloat(String key) {
        return this.getFloatOf(this.defaults.get(key), 0.0f);
    }

    @Override
    public long getDefaultLong(String key) {
        return this.getLongOf(this.defaults.get(key), 0L);
    }

    @Override
    public boolean getDefaultBoolean(String key) {
        return this.getBooleanOf(this.defaults.get(key), false);
    }

    @Override
    public void set(String key, Object value, boolean flush) {
        if (!this.constants.containsKey(key)) {
            super.set(key, value, flush);
        }
    }

    public void setForcefully(String key, Object value, boolean flush) {
        super.set(key, value, flush);
    }

    public void setForcefully(String key, Object value) {
        this.setForcefully(key, value, true);
    }

    @Override
    public void save() throws IOException {
        if (!this.isSaveable()) {
            throw new UnsupportedOperationException();
        }
        Properties temp = Configuration.copyProperties(this.properties);
        for (String key : this.constants.keySet()) {
            temp.remove(key);
        }
        File file1 = (File)this.input;
        temp.store(new FileOutputStream(file1), this.comments);
    }

    public File getFile() {
        return !this.isSaveable() ? null : (File)this.input;
    }

    private List<Locale> getSupportedLocales() {
        this.log("Searching for supported locales...");
        Pattern lang_pattern = Pattern.compile("lang/([\\w]+)$");
        File file = FileUtil.getRunningJar();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        try {
            URL e = file.toURI().toURL();
            ZipInputStream zip = new ZipInputStream(e.openStream());
            while (true) {
                ZipEntry e1;
                if ((e1 = zip.getNextEntry()) == null) {
                    return locales.isEmpty() ? this.defaultLocales : locales;
                }
                String name = e1.getName();
                Matcher mt = lang_pattern.matcher(name);
                if (!mt.matches()) continue;
                this.log("Found locale:", mt.group(1));
                locales.add(Configuration.getLocaleOf(mt.group(1)));
            }
        }
        catch (Exception var9) {
            this.log("Cannot get locales!", var9);
            return this.defaultLocales;
        }
    }

    private static List<Locale> getDefaultLocales() {
        ArrayList<Locale> l = new ArrayList<Locale>();
        l.add(Configuration.getLocaleOf("en_US"));
        l.add(Configuration.getLocaleOf("ru_RU"));
        l.add(Configuration.getLocaleOf("uk_UA"));
        return l;
    }

    public static Locale getLocaleOf(String locale) {
        if (locale == null) {
            return null;
        }
        for (Locale cur : Locale.getAvailableLocales()) {
            if (!cur.toString().equals(locale)) continue;
            return cur;
        }
        return null;
    }

    public static enum ConnectionQuality {
        GOOD(2, 5, 6, 15000),
        NORMAL(5, 10, 3, 45000),
        BAD(10, 20, 1, 120000);

        private final int minTries;
        private final int maxTries;
        private final int maxThreads;
        private final int timeout;
        private final int[] configuration;

        private ConnectionQuality(int minTries, int maxTries, int maxThreads, int timeout) {
            this.minTries = minTries;
            this.maxTries = maxTries;
            this.maxThreads = maxThreads;
            this.timeout = timeout;
            this.configuration = new int[]{minTries, maxTries, maxThreads};
        }

        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            for (ConnectionQuality cur : ConnectionQuality.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }

        public static ConnectionQuality get(String val) {
            for (ConnectionQuality cur : ConnectionQuality.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return cur;
            }
            return null;
        }

        public int[] getConfiguration() {
            return this.configuration;
        }

        public int getMinTries() {
            return this.minTries;
        }

        public int getMaxTries() {
            return this.maxTries;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public int getTries(boolean fast) {
            return fast ? this.minTries : this.maxTries;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ConnectionQuality getDefault() {
            return GOOD;
        }
    }

    public static enum ConsoleType {
        GLOBAL,
        MINECRAFT,
        NONE;


        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            for (ConsoleType cur : ConsoleType.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }

        public static ConsoleType get(String val) {
            for (ConsoleType cur : ConsoleType.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return cur;
            }
            return null;
        }

        public MinecraftLauncher.ConsoleVisibility getVisibility() {
            return this == GLOBAL ? MinecraftLauncher.ConsoleVisibility.NONE : (this == MINECRAFT ? MinecraftLauncher.ConsoleVisibility.ALWAYS : MinecraftLauncher.ConsoleVisibility.ON_CRASH);
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ConsoleType getDefault() {
            return NONE;
        }
    }

    public static enum ActionOnLaunch {
        HIDE,
        EXIT,
        NOTHING;


        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            for (ActionOnLaunch cur : ActionOnLaunch.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }

        public static ActionOnLaunch get(String val) {
            for (ActionOnLaunch cur : ActionOnLaunch.values()) {
                if (!cur.toString().equalsIgnoreCase(val)) continue;
                return cur;
            }
            return null;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ActionOnLaunch getDefault() {
            return HIDE;
        }
    }
}

