/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.scenes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ru.turikhay.tlauncher.entity.ServerInfoPage;
import ru.turikhay.tlauncher.entity.ServerInfoPageContainer;
import ru.turikhay.tlauncher.managers.popup.menu.page.ServerInfoPageController;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.scenes.PseudoScene;
import ru.turikhay.tlauncher.ui.swing.ImageButton;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;

public class ServerPageManagerScene
extends PseudoScene {
    private ServerInfoPageController serverInfoPageController;
    private ServerInfoPageContainer model;
    private PanelPageManager panel;

    public ServerPageManagerScene(MainPane mp, ServerInfoPageController serverInfoPageController, ServerInfoPageContainer model) {
        super(mp);
        this.serverInfoPageController = serverInfoPageController;
        this.model = model;
        this.panel = new PanelPageManager();
        this.panel.setLocation(this.getWidth() / 2 - this.panel.getWidth() / 2, this.getHeight() / 2 - this.panel.getHeight() / 2);
        this.add((Component)this.panel);
    }

    public void showScene() {
        this.getMainPane().setScene(this);
    }

    class PanelPageManager
    extends CenterPanel {
        private ImageButton back;
        private JPanel panelServers;

        public PanelPageManager() {
            super(squareInsets);
            int height = PanelPageManager.squareInsets.bottom + PanelPageManager.squareInsets.bottom;
            ExtendedPanel p = new ExtendedPanel(new FlowLayout());
            BorderPanel panel = new BorderPanel(0, 5);
            LocalizableLabel label = new LocalizableLabel("server.page.title");
            Font f = label.getFont();
            label.setFont(new Font(f.getName(), f.getStyle(), (int)((double)f.getSize() * 1.3)));
            p.add((Component)label);
            panel.setNorth(p);
            this.panelServers = new JPanel();
            this.panelServers.setLayout(new BoxLayout(this.panelServers, 1));
            this.panelServers.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            height = (int)((double)height + label.getPreferredSize().getHeight());
            Component strut = Box.createVerticalStrut(1);
            for (ServerInfoPage dim : ServerPageManagerScene.this.model.getList()) {
                ServerPageManagerScene serverPageManagerScene = ServerPageManagerScene.this;
                serverPageManagerScene.getClass();
                ServerView view = serverPageManagerScene.new ServerView(dim);
                this.panelServers.add(view);
                strut = Box.createVerticalStrut(1);
                strut.setBackground(Color.GRAY);
                this.panelServers.add(strut);
            }
            this.panelServers.remove(strut);
            height = (int)((double)height + this.panelServers.getPreferredSize().getHeight());
            panel.setCenter(this.panelServers);
            ExtendedPanel buttons1 = new ExtendedPanel(new FlowLayout());
            this.back = new ImageButton("home.png");
            Dimension dim1 = this.back.getPreferredSize();
            dim1.setSize(dim1.getWidth() * 3.0, (double)dim1.height);
            this.back.setPreferredSize(dim1);
            this.back.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerPageManagerScene.this.getMainPane().openDefaultScene();
                }
            });
            buttons1.add((Component)this.back);
            height = (int)((double)height + buttons1.getPreferredSize().getHeight());
            panel.setSouth(buttons1);
            this.add((Component)panel);
            this.setSize(new Dimension(550, height += 20));
        }
    }

    class ServerView
    extends JPanel {
        private Font fontTop;
        private Font fontBotton;
        private JLabel topLabel;
        private JLabel bottonLabel;
        private JLabel versionLabel;
        private Color colorDefault;
        private Color colorMouseUnder;
        private static final int WIDTH_DESC = 440;
        private static final int WIDTH_VERSION = 50;
        private ServerInfoPage server;

        public ServerView(ServerInfoPage server) {
            this.server = server;
            this.setLayout(new FlowLayout(0));
            this.colorDefault = server.getColor();
            this.colorMouseUnder = new Color(this.colorDefault.getRed(), this.colorDefault.getGreen() - 30, this.colorDefault.getBlue());
            this.fontTop = new Font("Sans-serif", 1, 17);
            this.fontBotton = new Font("Sans-serif", 0, 13);
            this.topLabel = new JLabel(server.getShortDescription());
            this.topLabel.setFont(this.fontTop);
            Dimension dTop = this.topLabel.getPreferredSize();
            dTop.width = 440;
            this.topLabel.setPreferredSize(dTop);
            this.bottonLabel = new JLabel(server.getAddDescription());
            this.bottonLabel.setFont(this.fontBotton);
            Dimension dBotton = this.bottonLabel.getPreferredSize();
            dBotton.width = 440;
            this.bottonLabel.setPreferredSize(dBotton);
            this.versionLabel = new JLabel(server.getVersion());
            int heightVersion = dBotton.height + dTop.height;
            Dimension dVersion = this.versionLabel.getSize();
            dVersion.setSize(50, heightVersion);
            this.versionLabel.setFont(this.fontTop);
            JPanel desc = new JPanel();
            desc.setLayout(new BoxLayout(desc, 1));
            desc.add(this.topLabel);
            desc.add(this.bottonLabel);
            this.add(desc);
            this.add(this.versionLabel);
            this.setBackground(this.colorDefault);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    ServerView.this.setBackground(ServerView.this.colorDefault);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ServerView.this.setBackground(ServerView.this.colorMouseUnder);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        TLauncher.getInstance().getPopupMenuManager().processingEvent(ServerView.this.server.getServerId(), e.getYOnScreen(), e.getXOnScreen());
                    }
                }
            });
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            Component[] array = this.getComponents();
            for (int i = 0; i < array.length; ++i) {
                array[i].setBackground(bg);
            }
        }

        public Color getColor() {
            return this.colorDefault;
        }
    }
}

