/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.editor.EditorIntegerRangeField;
import ru.turikhay.tlauncher.ui.editor.EditorTextField;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.VPanel;
import ru.turikhay.util.Range;
import ru.turikhay.util.U;

public class SettingsProxy
extends VPanel
implements EditorField {
    private static final String path = "settings.connection.proxy";
    private static final String block = "proxyselect";
    private final ExtendedPanel proxyTypePanel;
    private final LinkedHashMap<Proxy.Type, ProxyLocRadio> typeMap = new LinkedHashMap();
    private final ButtonGroup group = new ButtonGroup();
    private final ProxySettingsPanel proxySettingsPanel;
    private final EditorTextField addressField;
    private final EditorTextField portField;

    SettingsProxy() {
        this.setAlignmentX(0.0f);
        List<Proxy.Type> typeList = Arrays.asList(Proxy.Type.values());
        for (Proxy.Type i$ : typeList) {
            ProxyLocRadio en = new ProxyLocRadio(null);
            en.setText(i$.name().toLowerCase());
            en.setAlignmentX(0.0f);
            en.setOpaque(false);
            this.group.add(en);
            this.typeMap.put(i$, en);
        }
        this.typeMap.get((Object)Proxy.Type.DIRECT).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    Blocker.block(SettingsProxy.this.proxySettingsPanel, SettingsProxy.block);
                }
            }
        });
        this.proxyTypePanel = new ExtendedPanel();
        this.proxyTypePanel.setAlignmentX(0.0f);
        this.add((Component)this.proxyTypePanel);
        ItemListener listener1 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    Blocker.unblock(SettingsProxy.this.proxySettingsPanel, SettingsProxy.block);
                }
            }
        };
        for (Map.Entry<Proxy.Type, ProxyLocRadio> en1 : this.typeMap.entrySet()) {
            this.proxyTypePanel.add((Component)en1.getValue());
            if (en1.getKey() == Proxy.Type.DIRECT) continue;
            en1.getValue().addItemListener(listener1);
        }
        this.proxySettingsPanel = new ProxySettingsPanel(null);
        this.proxySettingsPanel.setAlignmentX(0.0f);
        this.add((Component)this.proxySettingsPanel);
        this.addressField = new EditorTextField("settings.connection.proxy.address", false);
        this.proxySettingsPanel.setCenter(this.addressField);
        this.portField = new EditorIntegerRangeField("settings.connection.proxy.port", new Range<Integer>(0, 65535));
        this.portField.setColumns(5);
        this.proxySettingsPanel.setEast(this.portField);
    }

    private Map.Entry<Proxy.Type, ProxyLocRadio> getSelectedType() {
        Map.Entry<Proxy.Type, ProxyLocRadio> en;
        Iterator<Map.Entry<Proxy.Type, ProxyLocRadio>> i$ = this.typeMap.entrySet().iterator();
        do {
            if (i$.hasNext()) continue;
            return null;
        } while (!(en = i$.next()).getValue().isSelected());
        return en;
    }

    private void setSelectedType(Proxy.Type type) {
        Map.Entry<Proxy.Type, ProxyLocRadio> en;
        Iterator<Map.Entry<Proxy.Type, ProxyLocRadio>> i$ = this.typeMap.entrySet().iterator();
        do {
            if (i$.hasNext()) continue;
            this.typeMap.get((Object)Proxy.Type.DIRECT).setSelected(true);
            return;
        } while ((en = i$.next()).getKey() != type);
        en.getValue().setSelected(true);
    }

    @Override
    public String getSettingsValue() {
        Map.Entry<Proxy.Type, ProxyLocRadio> selected = this.getSelectedType();
        if (selected != null && selected.getKey() != Proxy.Type.DIRECT) {
            U.log(selected.getKey().name().toLowerCase() + ';' + this.addressField.getValue() + ';' + this.portField.getValue());
            return selected.getKey().name().toLowerCase() + ';' + this.addressField.getValue() + ';' + this.portField.getValue();
        }
        U.log("selected is", selected, "so null");
        return null;
    }

    @Override
    public void setSettingsValue(String value) {
    }

    @Override
    public boolean isValueValid() {
        Map.Entry<Proxy.Type, ProxyLocRadio> selected = this.getSelectedType();
        return selected != null && selected.getKey() != Proxy.Type.DIRECT ? this.addressField.isValueValid() && this.portField.isValueValid() : true;
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(this, reason);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(this, reason);
    }

    private class ProxyLocRadio
    extends JRadioButton
    implements LocalizableComponent {
        private String currentType;

        private ProxyLocRadio() {
        }

        @Override
        public void setText(String proxyType) {
            this.currentType = proxyType;
            String text = Localizable.get("settings.connection.proxy.type." + proxyType);
            if (StringUtils.isBlank(text)) {
                text = proxyType;
            }
            super.setText(text);
        }

        @Override
        public void updateLocale() {
            this.setText(this.currentType);
        }

        ProxyLocRadio(Object x1) {
            this();
        }
    }

    private class ProxySettingsPanel
    extends BorderPanel
    implements Blockable {
        private ProxySettingsPanel() {
        }

        @Override
        public void block(Object reason) {
            Blocker.blockComponents(this, reason);
        }

        @Override
        public void unblock(Object reason) {
            Blocker.unblockComponents(this, reason);
        }

        ProxySettingsPanel(Object x1) {
            this();
        }
    }
}

