/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.swing.ImageButton;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerListener;
import ru.turikhay.tlauncher.ui.versions.VersionList;

public class VersionRefreshButton
extends ImageButton
implements VersionHandlerListener,
Blockable {
    private static final long serialVersionUID = -7148657244927244061L;
    private static final String PREFIX = "version.manager.refresher.";
    private static final String MENU = "version.manager.refresher.menu.";
    final VersionHandler handler;
    private final JPopupMenu menu;
    private final LocalizableMenuItem local;
    private final LocalizableMenuItem remote;
    private ButtonState state;

    VersionRefreshButton(VersionList list) {
        this.handler = list.handler;
        this.menu = new JPopupMenu();
        this.local = new LocalizableMenuItem("version.manager.refresher.menu.local");
        this.local.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRefreshButton.this.handler.refresh();
            }
        });
        this.menu.add(this.local);
        this.remote = new LocalizableMenuItem("version.manager.refresher.menu.remote");
        this.remote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRefreshButton.this.handler.asyncRefresh();
            }
        });
        this.menu.add(this.remote);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRefreshButton.this.onPressed();
            }
        });
        this.setState(ButtonState.REFRESH);
        this.handler.addListener(this);
    }

    void onPressed() {
        switch (SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionRefreshButton$ButtonState[this.state.ordinal()]) {
            case 1: {
                this.handler.stopRefresh();
                break;
            }
            case 2: {
                this.menu.show(this, 0, this.getHeight());
            }
        }
    }

    private void setState(ButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.setImage(state.image);
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
        this.setState(ButtonState.CANCEL);
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
        this.setState(ButtonState.REFRESH);
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
    }

    @Override
    public void onVersionDeselected() {
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    @Override
    public void block(Object reason) {
        if (!reason.equals("refresh")) {
            this.setEnabled(false);
        }
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    static enum ButtonState {
        REFRESH("refresh.png"),
        CANCEL("cancel.png");

        final Image image;

        private ButtonState(String image) {
            this.image = ImageCache.getImage(image);
        }
    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionRefreshButton$ButtonState = new int[ButtonState.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionRefreshButton$ButtonState[ButtonState.CANCEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$ui$versions$VersionRefreshButton$ButtonState[ButtonState.REFRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

