/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.U;

public class FileUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger log4j = Logger.getLogger(FileUtil.class);
    public static final String NAME_ARCHIVE = "logOfFiles.zip";

    public static Charset getCharset() {
        try {
            return Charset.forName(DEFAULT_CHARSET);
        }
        catch (Exception var1) {
            var1.printStackTrace();
            return null;
        }
    }

    public static void writeFile(File file, String text) throws IOException {
        FileUtil.createFile(file);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, DEFAULT_CHARSET);
        ow.write(text);
        ow.close();
        os.close();
    }

    public static String archiveFile(String path) {
        log4j.info("archive files");
        log4j.debug("path = " + path);
        if (path == null || path.isEmpty()) {
            path = MinecraftUtil.getWorkingDirectory().getPath() + File.separator + "logs" + File.separator + "log4jFiles";
        }
        try {
            String var20;
            try (ZipOutputStream e = new ZipOutputStream(new FileOutputStream(path + File.separator + NAME_ARCHIVE));){
                File folder = new File(path);
                for (File file : folder.listFiles()) {
                    if (file.getName().equals(NAME_ARCHIVE)) continue;
                    ZipEntry zipEntry = new ZipEntry(file.getName());
                    e.putNextEntry(zipEntry);
                    FileUtil.writeZipEntry(e, file);
                }
                var20 = path + File.separator + NAME_ARCHIVE;
            }
            return var20;
        }
        catch (IOException var19) {
            log4j.error("operation of archive takes place error ", var19);
            return null;
        }
    }

    public static void writeZipEntry(ZipOutputStream zip, File fileRead) throws IOException {
        try (FileInputStream e = new FileInputStream(fileRead);){
            byte[] x2 = new byte[8192];
            while (e.read(x2) != -1) {
                zip.write(x2);
            }
        }
        catch (IOException var15) {
            throw new IOException(var15);
        }
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    public static String readStream(InputStream is, String charset) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(is), charset);){
            String var5;
            StringBuilder b = new StringBuilder();
            while (reader.ready()) {
                b.append((char)reader.read());
            }
            String string = var5 = b.toString();
            return string;
        }
    }

    public static String getTextResource(URL url, String charset) throws IOException {
        return FileUtil.readStream(url.openStream(), charset);
    }

    public static synchronized String getTextResource(URL url) throws IOException {
        return FileUtil.getTextResource(url, DEFAULT_CHARSET);
    }

    public static String readFile(File file, String charset) throws IOException {
        return FileUtil.readStream(new FileInputStream(file), charset);
    }

    public static String readFile(File file) throws IOException {
        return FileUtil.readFile(file, DEFAULT_CHARSET);
    }

    public static String getFilename(String path) {
        String[] folders = path.split("/");
        int size = folders.length;
        return size == 0 ? "" : folders[size - 1];
    }

    public static String getFilename(URL url) {
        return FileUtil.getFilename(url.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDigest(File file, String algorithm, int hashLength) {
        Object var6;
        DigestInputStream stream = null;
        try {
            int read;
            stream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance(algorithm));
            byte[] ignored = new byte[65536];
            while ((read = stream.read(ignored)) > 0) {
            }
            String string = String.format("%1$0" + hashLength + "x", new BigInteger(1, stream.getMessageDigest().digest()));
            FileUtil.close(stream);
            return string;
        }
        catch (Exception var10) {
            var6 = null;
        }
        finally {
            FileUtil.close(stream);
        }
        return var6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyAndDigest(InputStream inputStream, OutputStream outputStream, String algorithm, int hashLength) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException var10) {
            throw new RuntimeException("Missing Digest. " + algorithm, var10);
        }
        byte[] buffer = new byte[65536];
        try {
            int read = inputStream.read(buffer);
            while (read >= 1) {
                digest.update(buffer, 0, read);
                outputStream.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
        }
        finally {
            FileUtil.close(inputStream);
            FileUtil.close(outputStream);
        }
        return String.format("%1$0" + hashLength + "x", new BigInteger(1, digest.digest()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createChecksum(File file, String algorithm) {
        BufferedInputStream fis = null;
        try {
            int numRead;
            fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(algorithm);
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            FileUtil.close(fis);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            FileUtil.close(fis);
        }
    }

    public static String getChecksum(File file, String algorithm) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        byte[] b = FileUtil.createChecksum(file, algorithm);
        if (b == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        byte[] arr$ = b;
        int len$ = b.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte cb = arr$[i$];
            result.append(Integer.toString((cb & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    private static void close(Closeable a) {
        try {
            a.close();
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    public static File getRunningJar() {
        try {
            return new File(URLDecoder.decode(FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath(), DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException var1) {
            throw new RuntimeException("Cannot get running file!", var1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest, boolean replace) throws IOException {
        if (dest.isFile()) {
            if (!replace) {
                return;
            }
        } else {
            FileUtil.createFile(dest);
        }
        BufferedInputStream is = null;
        FilterOutputStream os = null;
        try {
            int length;
            is = new BufferedInputStream(new FileInputStream(source));
            os = new BufferedOutputStream(new FileOutputStream(dest));
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                ((BufferedOutputStream)os).write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static void deleteFile(File file) {
        boolean onExit;
        boolean bl = onExit = !file.delete();
        if (onExit) {
            file.deleteOnExit();
        } else {
            File[] list;
            File parent = file.getParentFile();
            if (parent != null && (list = parent.listFiles()) != null && list.length <= 0) {
                FileUtil.deleteFile(parent);
            }
        }
    }

    public static void deleteFile(String path) {
        FileUtil.deleteFile(new File(path));
    }

    public static void deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory: " + dir.getAbsolutePath());
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                FileUtil.deleteDirectory(file);
                continue;
            }
            FileUtil.deleteFile(file);
        }
        FileUtil.deleteFile(dir);
    }

    public static File makeTemp(File file) throws IOException {
        FileUtil.createFile(file);
        file.deleteOnExit();
        return file;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] getFile(File archive, String requestedFile) throws IOException {
        out = new ByteArrayOutputStream();
        in = null;
        try {
            in = new ZipInputStream(new FileInputStream(archive));
            block4: while (true) {
                if ((entry = in.getNextEntry()) == null) {
                    var6_6 = out.toByteArray();
                    return var6_6;
                }
                if (!entry.getName().equals(requestedFile)) continue;
                buf = new byte[1024];
                while (true) {
                    if ((len = in.read(buf)) > 0) ** break;
                    continue block4;
                    out.write(buf, 0, len);
                }
                break;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            out.close();
        }
    }

    public static boolean createFolder(File dir) throws IOException {
        if (dir == null) {
            throw new NullPointerException();
        }
        if (dir.isDirectory()) {
            return false;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create folders: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new IOException("Ceated directory is not accessible: " + dir.getAbsolutePath());
        }
        return true;
    }

    public static boolean createFolder(String dir) throws IOException {
        return dir == null ? false : FileUtil.createFolder(new File(dir));
    }

    public static boolean folderExists(String path) {
        if (path == null) {
            return false;
        }
        File folder = new File(path);
        return folder.isDirectory();
    }

    public static boolean fileExists(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.isFile();
    }

    public static void createFile(File file) throws IOException {
        if (!file.isFile()) {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.createNewFile()) {
                throw new IOException("Cannot create file, or it was created during runtime: " + file.getAbsolutePath());
            }
        }
    }

    public static void createFile(String file) throws IOException {
        FileUtil.createFile(new File(file));
    }

    public static void unZip(File zip, File folder, boolean replace) throws IOException {
        ZipEntry ze;
        FileUtil.createFolder(folder);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
        byte[] buffer = new byte[1024];
        while ((ze = zis.getNextEntry()) != null) {
            int len;
            String fileName = ze.getName();
            File newFile = new File(folder, fileName);
            if (!replace && newFile.isFile()) {
                U.log("[UnZip] File exists:", newFile.getAbsoluteFile());
                continue;
            }
            U.log("[UnZip]", newFile.getAbsoluteFile());
            FileUtil.createFile(newFile);
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(newFile));
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
        }
        zis.closeEntry();
        zis.close();
    }

    public static String getResource(URL resource, String charset) throws IOException {
        BufferedInputStream is = new BufferedInputStream(resource.openStream());
        InputStreamReader reader = new InputStreamReader((InputStream)is, charset);
        StringBuilder b = new StringBuilder();
        while (reader.ready()) {
            b.append((char)reader.read());
        }
        reader.close();
        return b.toString();
    }

    public static String getResource(URL resource) throws IOException {
        return FileUtil.getResource(resource, DEFAULT_CHARSET);
    }

    public static String getFolder(URL url, String separator) {
        String[] folders = url.toString().split(separator);
        String s = "";
        for (int i = 0; i < folders.length - 1; ++i) {
            s = s + folders[i] + separator;
        }
        return s;
    }

    public static String getFolder(URL url) {
        return FileUtil.getFolder(url, "/");
    }

    private static File getNeighborFile(File file, String filename) {
        File parent = file.getParentFile();
        if (parent == null) {
            parent = new File("/");
        }
        return new File(parent, filename);
    }

    public static File getNeighborFile(String filename) {
        return FileUtil.getNeighborFile(FileUtil.getRunningJar(), filename);
    }

    public static String getExtension(File f) {
        if (!f.isFile() && f.isDirectory()) {
            return null;
        }
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static void rewriteFile(File file, String server) throws IOException {
        try (OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), DEFAULT_CHARSET);){
            ow.write(server);
        }
    }
}

