/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.extended;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public class ExtendedPanel
extends JPanel {
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private Insets insets;
    private float opacity = 1.0f;
    private AlphaComposite aComp;

    public ExtendedPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.setOpaque(false);
    }

    public ExtendedPanel(LayoutManager layout) {
        this(layout, true);
    }

    public ExtendedPanel(boolean isDoubleBuffered) {
        this(new FlowLayout(), isDoubleBuffered);
    }

    public ExtendedPanel() {
        this(true);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        if (!(f >= 0.0f) || !(f <= 1.0f)) {
            throw new IllegalArgumentException("opacity must be in [0;1]");
        }
        this.opacity = f;
        this.aComp = AlphaComposite.getInstance(3, f);
        this.repaint();
    }

    @Override
    public Insets getInsets() {
        return this.insets == null ? super.getInsets() : this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Component add(Component comp) {
        super.add(comp);
        if (comp == null) {
            return null;
        }
        MouseListener[] compareListeners = comp.getMouseListeners();
        Iterator<MouseListener> i$ = this.mouseListeners.iterator();
        while (i$.hasNext()) {
            MouseListener listener;
            MouseListener add = listener = i$.next();
            MouseListener[] arr$ = compareListeners;
            int len$ = compareListeners.length;
            for (int i$1 = 0; i$1 < len$; ++i$1) {
                MouseListener compareListener = arr$[i$1];
                if (!listener.equals(compareListener)) continue;
                add = null;
                break;
            }
            if (add == null) continue;
            comp.addMouseListener(add);
        }
        return comp;
    }

    public void add(Component ... components) {
        if (components == null) {
            throw new NullPointerException();
        }
        Component[] arr$ = components;
        int len$ = components.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Component comp = arr$[i$];
            this.add(comp);
        }
    }

    public void add(Component component0, Component component1) {
        this.add(new Component[]{component0, component1});
    }

    @Override
    public synchronized void addMouseListener(MouseListener listener) {
        if (listener != null) {
            this.mouseListeners.add(listener);
            for (Component comp : this.getComponents()) {
                comp.addMouseListener(listener);
            }
        }
    }

    protected synchronized void addMouseListenerOriginally(MouseListener listener) {
        super.addMouseListener(listener);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener listener) {
        if (listener != null) {
            this.mouseListeners.remove(listener);
            for (Component comp : this.getComponents()) {
                comp.removeMouseListener(listener);
            }
        }
    }

    protected synchronized void removeMouseListenerOriginally(MouseListener listener) {
        super.removeMouseListener(listener);
    }

    public boolean contains(Component comp) {
        if (comp == null) {
            return false;
        }
        for (Component c : this.getComponents()) {
            if (!comp.equals(c)) continue;
            return true;
        }
        return false;
    }

    public Insets setInsets(int top, int left, int bottom, int right) {
        Insets insets = new Insets(top, left, bottom, right);
        this.setInsets(insets);
        return insets;
    }

    @Override
    protected void paintComponent(Graphics g0) {
        if (this.opacity == 1.0f) {
            super.paintComponent(g0);
        } else {
            Graphics2D g = (Graphics2D)g0;
            g.setComposite(this.aComp);
            super.paintComponent(g0);
        }
    }
}

