/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.turikhay.util.async.AsyncContainerLockedException;
import ru.turikhay.util.async.AsyncObject;
import ru.turikhay.util.async.AsyncObjectGotErrorException;
import ru.turikhay.util.async.AsyncObjectNotReadyException;

public class AsyncObjectContainer<T> {
    private final List<AsyncObject<T>> objects = new ArrayList<AsyncObject<T>>();
    private final Map<AsyncObject<T>, T> values = new LinkedHashMap<AsyncObject<T>, T>();
    private boolean executionLock;

    public AsyncObjectContainer() {
    }

    public AsyncObjectContainer(AsyncObject<T>[] asyncObjects) {
        this();
        AsyncObject<T>[] arr$ = asyncObjects;
        int len$ = asyncObjects.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            AsyncObject<T> object = arr$[i$];
            this.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AsyncObject<T>, T> execute() {
        this.executionLock = true;
        this.values.clear();
        List<AsyncObject<T>> var1 = this.objects;
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            int i = 0;
            int size = this.objects.size();
            for (AsyncObject<T> object : this.objects) {
                object.start();
            }
            while (i < size) {
                for (AsyncObject<T> object : this.objects) {
                    try {
                        if (this.values.containsKey(object)) continue;
                        this.values.put(object, object.getValue());
                        ++i;
                    }
                    catch (AsyncObjectNotReadyException asyncObjectNotReadyException) {
                    }
                    catch (AsyncObjectGotErrorException var9) {
                        this.values.put(object, null);
                        ++i;
                    }
                }
            }
        }
        this.executionLock = false;
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        List<AsyncObject<T>> var2 = this.objects;
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        List<AsyncObject<T>> var2 = this.objects;
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<AsyncObject<T>> var1 = this.objects;
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.clear();
        }
    }
}

