/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PaintPanel
extends JPanel {
    private Paint _backgroundPaint;
    protected Color _startColor;
    protected Color _endColor;
    protected boolean _isVertical;

    public PaintPanel() {
    }

    public PaintPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public PaintPanel(LayoutManager layout) {
        super(layout);
    }

    public PaintPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public Paint getBackgroundPaint() {
        return this._backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this._backgroundPaint = backgroundPaint;
    }

    public static TexturePaint createTexturePaint(JPanel panel, Image img, int x, int y, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D tG2 = bi.createGraphics();
        tG2.drawImage(img, x, y, Color.white, panel);
        Rectangle r = new Rectangle(0, 0, w, h);
        return new TexturePaint(bi, r);
    }

    public void setGradientPaint(Color startColor, Color endColor, boolean isVertical) {
        this.setStartColor(startColor);
        this.setEndColor(endColor);
        this.setVertical(isVertical);
    }

    public Color getStartColor() {
        return this._startColor;
    }

    public void setStartColor(Color startColor) {
        this._startColor = startColor;
    }

    public Color getEndColor() {
        return this._endColor;
    }

    public void setEndColor(Color endColor) {
        this._endColor = endColor;
    }

    public boolean isVertical() {
        return this._isVertical;
    }

    public void setVertical(boolean vertical) {
        this._isVertical = vertical;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getStartColor() != null && this.getEndColor() != null) {
            JideSwingUtilities.fillGradient((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.getStartColor(), this.getEndColor(), this.isVertical());
        } else if (this.isOpaque() && this.getBackgroundPaint() != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.getBackgroundPaint());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

