/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import ru.turikhay.util.U;

class AuthenticatorService {
    AuthenticatorService() {
    }

    private static void log(Object ... o) {
        U.log("[AUTHSERV]", o);
    }

    private static void debug(Object ... o) {
    }

    private static HttpURLConnection createUrlConnection(URL url) throws IOException {
        Validate.notNull(url);
        AuthenticatorService.debug("Opening connection to " + url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(U.getProxy());
        connection.setConnectTimeout(U.getConnectionTimeout());
        connection.setReadTimeout(U.getReadTimeout());
        connection.setUseCaches(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String performPostRequest(URL url, String post, String contentType) throws IOException {
        String var9;
        Validate.notNull(url);
        Validate.notNull(post);
        Validate.notNull(contentType);
        HttpURLConnection connection = AuthenticatorService.createUrlConnection(url);
        byte[] postAsBytes = post.getBytes(Charsets.UTF_8);
        connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
        connection.setDoOutput(true);
        AuthenticatorService.debug("Writing POST data to " + url + ": " + post);
        OutputStream outputStream = null;
        try {
            outputStream = connection.getOutputStream();
            IOUtils.write(postAsBytes, outputStream);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
        AuthenticatorService.debug("Reading data from " + url);
        InputStream inputStream = null;
        try {
            String result;
            inputStream = connection.getInputStream();
            String e = IOUtils.toString(inputStream, Charsets.UTF_8);
            AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
            AuthenticatorService.debug("Response: " + e);
            String string = result = e;
            return string;
        }
        catch (IOException var18) {
            IOUtils.closeQuietly(inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                AuthenticatorService.debug("Request failed", var18);
                throw var18;
            }
            AuthenticatorService.debug("Reading error page from " + url);
            String result = IOUtils.toString(inputStream, Charsets.UTF_8);
            AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
            AuthenticatorService.debug("Response: " + result);
            var9 = result;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return var9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String performGetRequest(URL url) throws IOException {
        String var5;
        Validate.notNull(url);
        HttpURLConnection connection = AuthenticatorService.createUrlConnection(url);
        AuthenticatorService.debug("Reading data from " + url);
        InputStream inputStream = null;
        try {
            String result;
            inputStream = connection.getInputStream();
            String e = IOUtils.toString(inputStream, Charsets.UTF_8);
            AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
            AuthenticatorService.debug("Response: " + e);
            String string = result = e;
            return string;
        }
        catch (IOException var9) {
            IOUtils.closeQuietly(inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                AuthenticatorService.debug("Request failed", var9);
                throw var9;
            }
            AuthenticatorService.debug("Reading error page from " + url);
            String result = IOUtils.toString(inputStream, Charsets.UTF_8);
            AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
            AuthenticatorService.debug("Response: " + result);
            var5 = result;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return var5;
    }

    public static URL constantURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException var2) {
            throw new Error("Couldn't create constant for " + url, var2);
        }
    }

    public static String buildQuery(Map<String, Object> query) {
        if (query == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : query.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            try {
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var6) {
                AuthenticatorService.log("Unexpected exception building query", var6);
            }
            if (entry.getValue() == null) continue;
            builder.append('=');
            try {
                builder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var5) {
                AuthenticatorService.log("Unexpected exception building query", var5);
            }
        }
        return builder.toString();
    }

    public static URL concatenateURL(URL url, String query) {
        try {
            return url.getQuery() != null && url.getQuery().length() > 0 ? new URL(url.getProtocol(), url.getHost(), url.getFile() + "&" + query) : new URL(url.getProtocol(), url.getHost(), url.getFile() + "?" + query);
        }
        catch (MalformedURLException var3) {
            throw new IllegalArgumentException("Could not concatenate given URL with GET arguments!", var3);
        }
    }
}

