/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.updater;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.Http;
import org.apache.commons.io.IOUtils;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.updater.Notices;
import ru.turikhay.tlauncher.updater.Stats;
import ru.turikhay.tlauncher.updater.Update;
import ru.turikhay.tlauncher.updater.UpdaterListener;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;

public class Updater {
    private final Gson gson = this.buildGson();
    private Update update;
    private final List<UpdaterListener> listeners = Collections.synchronizedList(new ArrayList());

    public Update getUpdate() {
        return this.update;
    }

    protected SearchResult findUpdate0() {
        SearchResult result = null;
        this.log("Requesting an update...");
        ArrayList<Throwable> errorList = new ArrayList<Throwable>();
        String get = "?version=" + Http.encode(String.valueOf(TLauncher.getVersion())) + "&client=" + Http.encode(TLauncher.getInstance().getSettings().getClient().toString());
        for (String updateUrl : this.getUpdateUrlList()) {
            long startTime = System.currentTimeMillis();
            this.log("Requesting from:", updateUrl);
            String response = null;
            try {
                URL e = new URL(updateUrl + get);
                this.log("Making request:", e);
                HttpURLConnection connection = Downloadable.setUp(e.openConnection(U.getProxy()), true);
                connection.setDoOutput(true);
                response = IOUtils.toString(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
                result = new SearchSucceeded(this.gson.fromJson(response, UpdaterResponse.class));
            }
            catch (Exception var11) {
                this.log("Failed to request from:", updateUrl, var11);
                if (response != null) {
                    this.log("Response:", response);
                }
                result = null;
                errorList.add(var11);
            }
            this.log("Request time:", System.currentTimeMillis() - startTime, "ms");
            if (result == null) continue;
            this.log("Successfully requested from:", updateUrl);
            this.log(result);
            break;
        }
        return result == null ? new SearchFailed(errorList) : result;
    }

    public SearchResult findUpdate() {
        try {
            SearchResult e = this.findUpdate0();
            this.dispatchResult(e);
            return e;
        }
        catch (Exception var2) {
            this.log(var2);
            return null;
        }
    }

    public void asyncFindUpdate() {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Updater.this.findUpdate();
            }
        });
    }

    public void addListener(UpdaterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UpdaterListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchResult(SearchResult result) {
        Updater.requireNotNull(result, "result");
        if (result instanceof SearchSucceeded) {
            Stats.setAllowed(result.getResponse().getStatsAllowed());
            List<UpdaterListener> var2 = this.listeners;
            List<UpdaterListener> list = this.listeners;
            synchronized (list) {
                for (UpdaterListener l : this.listeners) {
                    l.onUpdaterSucceeded((SearchSucceeded)result);
                }
            }
        }
        if (!(result instanceof SearchFailed)) {
            throw new IllegalArgumentException("unknown result of " + result.getClass());
        }
        List<UpdaterListener> var2 = this.listeners;
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onUpdaterErrored((SearchFailed)result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdaterRequests() {
        List<UpdaterListener> var1 = this.listeners;
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onUpdaterRequesting(this);
            }
        }
    }

    protected List<String> getUpdateUrlList() {
        return Arrays.asList(TLauncher.getUpdateRepos());
    }

    protected Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Notices.class), new Notices.Deserializer()).registerTypeAdapter((Type)((Object)Update.class), new Update.Deserializer()).create();
    }

    protected void log(Object ... o) {
        U.log("[Updater]", o);
    }

    private static <T> T requireNotNull(T obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name);
        }
        return obj;
    }

    public static class UpdaterResponse {
        private Update update;
        private boolean allowStats;

        public final Update getUpdate() {
            return this.update;
        }

        public final boolean getStatsAllowed() {
            return this.allowStats;
        }

        public String toString() {
            return "UpdaterResponse{update=" + this.update + "}";
        }
    }

    public abstract class SearchResult {
        protected final UpdaterResponse response;

        public SearchResult(UpdaterResponse response) {
            this.response = response;
        }

        public final UpdaterResponse getResponse() {
            return this.response;
        }

        public final Updater getUpdater() {
            return Updater.this;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{response=" + this.response + "}";
        }
    }

    public class SearchSucceeded
    extends SearchResult {
        public SearchSucceeded(UpdaterResponse response) {
            super(response);
        }
    }

    public class SearchFailed
    extends SearchResult {
        protected final List<Throwable> errorList;

        public SearchFailed(List<Throwable> list) {
            super(null);
            this.errorList = new ArrayList<Throwable>();
            for (Throwable t : list) {
                if (t != null) continue;
                throw new NullPointerException();
            }
            this.errorList.addAll(list);
        }

        public final List<Throwable> getCauseList() {
            return this.errorList;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "{errors=" + this.errorList + "}";
        }
    }
}

