/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.salf.connection;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Scanner;
import org.apache.log4j.Logger;
import ru.turikhay.tlauncher.exceptions.ConnectServerConfig;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.salf.connection.ConfigSeacher;
import ru.turikhay.util.salf.connection.ServerEntity;
import ru.turikhay.util.salf.connection.TransferFilesAbstract;
import ru.turikhay.util.salf.connection.TransferLog;

public class TransferLogImpl
extends TransferFilesAbstract {
    private static Logger log = Logger.getLogger(TransferLog.class);
    private static final String FILE_SERVER = "ConfigSALF.json";
    private ConfigSeacher configSeacher = new ConfigSeacher(TLauncher.getServerUrl(), "ConfigSALF.json");

    @Override
    public void sendFiles(String pathArchive) throws IOException {
        int portTransfer;
        log.trace("sendFiles()");
        log.debug("path  of archive file is " + pathArchive);
        if (pathArchive == null) {
            throw new NullPointerException("path of archive is null");
        }
        File file = new File(pathArchive);
        ServerEntity server = null;
        try {
            server = this.configSeacher.readServer();
            portTransfer = this.getPortTransfer(server);
        }
        catch (ConnectServerConfig var44) {
            this.configSeacher.saveConfigFromServer();
            server = this.configSeacher.readServer();
            try {
                portTransfer = this.getPortTransfer(server);
            }
            catch (ConnectServerConfig var43) {
                throw new IOException(var43);
            }
        }
        long sizeFile = file.length();
        byte[] array = new byte[65536];
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(pathArchive), 65536);
             Socket x2 = new Socket();){
            long i;
            x2.connect(new InetSocketAddress(server.getUrl(), portTransfer), 30000);
            DataOutputStream x21 = new DataOutputStream(x2.getOutputStream());
            Scanner reader = new Scanner(x2.getInputStream(), "UTF-8");
            x21.writeLong(sizeFile);
            log.debug("size file = " + sizeFile);
            long read = inputStream.read(array);
            for (i = 0L; i < sizeFile && read != -1L; i += read) {
                x21.write(array, 0, (int)read);
                read = inputStream.read(array);
            }
            x21.flush();
            log.debug("bytes of file read and write to the stream=" + i);
            if (reader.hasNextLine()) {
                log.trace("answer of server is " + reader.nextLine());
            } else {
                log.trace("answer of server is null");
            }
            x21.close();
            reader.close();
        }
    }
}

