/*
 * Decompiled with CFR 0.152.
 */
package com.hea3ven.tools.bootstrap;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class Bootstrap {
    private static final Logger logger = LogManager.getLogger((String)"H3NTBootstrap.Bootstrap");
    public static final String version = "1.1.1";
    private static boolean init = false;
    private Map<String, LibEntry> libs = Maps.newHashMap();

    @Deprecated
    public static void require(String modId, String versionPattern) {
        throw new BootstrapError("Mod " + modId + " is using an old version of the bootstrap");
    }

    public static void init() {
        if (init) {
            return;
        }
        logger.info("initializing");
        init = true;
        Bootstrap bs = new Bootstrap();
        bs.discover();
        logger.info("loading libraries");
        bs.load();
    }

    private static boolean matches(String versionPattern, String version) {
        return Pattern.matches(Pattern.quote(versionPattern).replace("x", "\\E[0-9]+\\Q"), version);
    }

    private static Path getLibsDir() {
        URL jarUrl = Bootstrap.class.getProtectionDomain().getCodeSource().getLocation();
        if (!jarUrl.getProtocol().equals("jar")) {
            return null;
        }
        String jarFilePath = null;
        try {
            jarFilePath = Paths.get(new URI(jarUrl.getPath())).toString();
        }
        catch (URISyntaxException e) {
            Throwables.propagate((Throwable)e);
        }
        if (jarFilePath.lastIndexOf(33) != -1) {
            jarFilePath = jarFilePath.substring(0, jarFilePath.lastIndexOf(33));
        }
        Path jarDir = Paths.get(jarFilePath, new String[0]).getParent();
        return jarDir.resolve("h3ntlibs");
    }

    private void checkVersion(String modId, String versionPattern) {
        if (!Bootstrap.matches(versionPattern, version)) {
            throw new RuntimeException("Mod '" + modId + "' requires Boostrap version " + versionPattern + ", but the current loaded version is " + version);
        }
    }

    private void addLib(String modid, File zipFile, String name, String version, String versionPattern) {
        if (!this.libs.containsKey(name)) {
            this.libs.put(name, new LibEntry(name));
        }
        this.libs.get(name).add(modid, zipFile, new ComparableVersion(version), versionPattern);
    }

    private void discover() {
        File mcDir = (File)ReflectionHelper.getPrivateValue(FMLRelaunchLog.class, null, (String[])new String[]{"minecraftHome"});
        Path modsDir = Paths.get(mcDir.toString(), "mods");
        String mcVersion = this.getMinecraftVersion();
        this.discoverFromDir(modsDir, mcVersion);
    }

    private void discoverFromDir(Path modsDir, String mcVersion) {
        try {
            DirectoryStream<Path> modDirs = Files.newDirectoryStream(modsDir);
            for (Path modPath : modDirs) {
                if (!Files.isRegularFile(modPath, new LinkOption[0])) {
                    if (!modPath.getFileName().toString().equals(mcVersion)) continue;
                    this.discoverFromDir(modPath, mcVersion);
                    continue;
                }
                this.discoverFromZip(modPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void discoverFromZip(Path modPath) {
        try (ZipFile jarZip = new ZipFile(modPath.toFile());){
            ZipEntry manifestEntry = jarZip.getEntry("META-INF/MANIFEST.MF");
            if (manifestEntry != null) {
                String bootstrapPath = this.getBootstrapPathFromManifest(jarZip, manifestEntry);
                if (bootstrapPath == null) {
                    return;
                }
                ZipEntry bootstrapEntry = jarZip.getEntry(bootstrapPath);
                if (bootstrapEntry == null) {
                    logger.warn("Could not get " + bootstrapPath + " from " + modPath.getFileName().toString());
                    return;
                }
                if (bootstrapEntry.isDirectory()) {
                    return;
                }
                InputStreamReader reader = new InputStreamReader(jarZip.getInputStream(bootstrapEntry));
                JsonObject bsObj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                String modid = bsObj.get("modid").getAsString();
                this.checkVersion(modid, bsObj.get("required").getAsString());
                JsonObject libs = bsObj.getAsJsonObject("libs");
                for (Map.Entry libEntry : libs.entrySet()) {
                    JsonObject lib = ((JsonElement)libEntry.getValue()).getAsJsonObject();
                    String version = lib.get("version").getAsString();
                    String required = lib.get("required").getAsString();
                    logger.debug("mod {} provides {} version {} and requires version {}", new Object[]{modid, libEntry.getKey(), version, required});
                    this.addLib(modid, modPath.toFile(), (String)libEntry.getKey(), version, required);
                }
            }
        }
        catch (IOException e) {
            logger.error("Could not open the jar file", (Throwable)e);
            return;
        }
    }

    private String getBootstrapPathFromManifest(ZipFile zip, ZipEntry manifestEntry) {
        Properties props = new Properties();
        try {
            props.load(zip.getInputStream(manifestEntry));
        }
        catch (IOException e) {
            return null;
        }
        if (props.containsKey("H3NTBootstrap")) {
            return props.getProperty("H3NTBootstrap");
        }
        return null;
    }

    private String getMinecraftVersion() {
        InputStream stream = Launch.classLoader.getResourceAsStream("net/minecraft/server/MinecraftServer.class");
        ClassNode serverClass = new ClassNode();
        try {
            new ClassReader(stream).accept((ClassVisitor)serverClass, 0);
        }
        catch (IOException e) {
            throw new RuntimeException("could not detect the running version");
        }
        VersionScannerVisitor versionScanner = new VersionScannerVisitor();
        for (MethodNode method : serverClass.methods) {
            method.accept((MethodVisitor)versionScanner);
        }
        if (versionScanner.version == null) {
            throw new RuntimeException("could not detect the running version");
        }
        return versionScanner.version;
    }

    private void load() {
        Path libsDir = Bootstrap.getLibsDir();
        if (libsDir == null) {
            return;
        }
        logger.debug("extracting libraries to {}", new Object[]{libsDir.toString()});
        for (LibEntry entry : this.libs.values()) {
            entry.checkCompatibility();
        }
        for (LibEntry entry : this.libs.values()) {
            this.loadLib(libsDir, entry);
        }
    }

    private void loadLib(Path libsDir, LibEntry entry) {
        String libJarName;
        block30: {
            libJarName = entry.getName() + "-" + entry.getVersion() + ".jar";
            logger.debug("loading library {}", new Object[]{libJarName});
            try {
                if (!Files.exists(libsDir, new LinkOption[0])) {
                    Files.createDirectory(libsDir, new FileAttribute[0]);
                }
                if (Files.exists(libsDir.resolve(libJarName), new LinkOption[0])) break block30;
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(libsDir);){
                    for (Path path : dirStream) {
                        if (!path.getFileName().toString().startsWith(entry.getName() + "-") || !path.toString().endsWith(".jar")) continue;
                        logger.debug("removing old file {}", new Object[]{path.toString()});
                        Files.delete(path);
                    }
                }
                var5_7 = null;
                try (ZipFile zip = new ZipFile(entry.getZipFile());){
                    ZipEntry zipEntry = zip.getEntry(String.format("libs/%s-%s.jar", entry.getName(), entry.getVersion()));
                    Files.copy(zip.getInputStream(zipEntry), libsDir.resolve(libJarName), new CopyOption[0]);
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new BootstrapError(String.format("Failed to extract library %s-%s", entry.getName(), entry.getVersion()), e);
            }
        }
        try {
            logger.debug("adding {} to classpath", new Object[]{libsDir.resolve(libJarName).toUri().toURL()});
            Launch.classLoader.addURL(libsDir.resolve(libJarName).toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new BootstrapError(String.format("Failed to load library %s-%s", entry.getName(), entry.getVersion()), e);
        }
    }

    class VersionScannerVisitor
    extends MethodVisitor {
        public String version;
        Pattern normalVer;
        Pattern snapVer;

        public VersionScannerVisitor() {
            super(262144);
            this.version = null;
            this.normalVer = Pattern.compile("^\\d+\\.\\d+(\\.\\d+)?$");
            this.snapVer = Pattern.compile("^\\d\\dw\\d+[a-z]$");
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof String) {
                String potentialVersion = (String)cst;
                if (this.normalVer.matcher(potentialVersion).matches()) {
                    this.setVersion(potentialVersion);
                } else if (this.snapVer.matcher(potentialVersion).matches()) {
                    this.setVersion(potentialVersion);
                }
            }
            super.visitLdcInsn(cst);
        }

        private void setVersion(String potentialVersion) {
            if (this.version != null && !this.version.equals(potentialVersion)) {
                throw new RuntimeException("could not detect running version, multiple matches");
            }
            this.version = potentialVersion;
        }
    }

    private class LibEntry {
        private final String name;
        private ComparableVersion latestVersion;
        private final Map<String, String> requests = Maps.newHashMap();
        private File zipFile;

        public LibEntry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.latestVersion.toString();
        }

        public File getZipFile() {
            return this.zipFile;
        }

        public void add(String modid, File zipFile, ComparableVersion version, String versionPattern) {
            if (this.latestVersion == null || this.latestVersion.compareTo(version) < 0) {
                this.latestVersion = version;
                this.zipFile = zipFile;
            }
            this.requests.put(modid, versionPattern);
        }

        public void checkCompatibility() {
            for (Map.Entry<String, String> entry : this.requests.entrySet()) {
                if (Bootstrap.matches(entry.getValue(), this.latestVersion.toString())) continue;
                throw new BootstrapError("Mod '" + entry.getKey() + "' requires library " + this.name + " with version " + entry.getValue() + " but the version " + this.latestVersion.toString() + " is loaded");
            }
        }
    }

    public static class BootstrapError
    extends RuntimeException {
        public BootstrapError(String msg) {
            super(msg);
        }

        public BootstrapError(String msg, Exception ex) {
            super(msg, ex);
        }
    }
}

