/*
 * Decompiled with CFR 0.152.
 */
package com.hea3ven.twintails;

import com.hea3ven.tools.commonutils.mod.ProxyModBase;
import com.hea3ven.tools.commonutils.mod.config.ConfigManagerBuilder;
import com.hea3ven.tools.commonutils.mod.config.FileConfigManagerBuilder;
import com.hea3ven.tools.commonutils.util.SidedCall;
import com.hea3ven.twintails.TwinTailType;
import com.hea3ven.twintails.client.ModelBakerTwinTails;
import com.hea3ven.twintails.item.ItemHairBand;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TwinTailsCommonProxy
extends ProxyModBase {
    private ItemHairBand hairBand;

    public TwinTailsCommonProxy() {
        super("twintails");
        SidedCall.run((Side)Side.CLIENT, (Runnable)new Runnable(){

            @Override
            public void run() {
                OBJLoader.INSTANCE.addDomain("twintails");
            }
        });
    }

    public void onPreInitEvent(FMLPreInitializationEvent event) {
        super.onPreInitEvent(event);
    }

    public void onInitEvent(FMLInitializationEvent event) {
        super.onInitEvent(event);
    }

    protected void registerConfig() {
        this.addConfigManager((ConfigManagerBuilder)new FileConfigManagerBuilder().setFileName("twintails.cfg").setDesc("TwinTails Configuration").addCategory("general").addValue("TwinTailsEffects", "false", Property.Type.BOOLEAN, "Enable to get effects while wearing certain twintails", (Consumer)new Consumer<Property>(){

            @Override
            public void accept(Property property) {
                ItemHairBand.twinTailsEffects = property.getBoolean();
            }
        }).endCategory().Update((Consumer)new Consumer<Configuration>(){

            @Override
            public void accept(Configuration configuration) {
                ConfigCategory gralCat = configuration.getCategory("general");
                if (gralCat.containsKey("VersionCheck")) {
                    gralCat.remove((Object)"VersionCheck");
                }
                if (gralCat.containsKey("VersionLatest")) {
                    gralCat.remove((Object)"VersionLatest");
                }
            }
        }));
    }

    protected void registerItems() {
        this.hairBand = (ItemHairBand)new ItemHairBand().func_77655_b("hairBand");
        String[] twinTailTypeVariants = new String[ItemHairBand.twinTailTypes.length];
        int i = 0;
        for (TwinTailType type : ItemHairBand.twinTailTypes) {
            twinTailTypeVariants[i++] = "hairband_" + type.getName();
        }
        this.addItem((Item)this.hairBand, "hairBand", twinTailTypeVariants);
    }

    protected void registerCreativeTabs() {
        this.addCreativeTab("twintails", new ItemStack((Item)this.hairBand, 1, 1));
        this.hairBand.func_77637_a(this.getCreativeTab("twintails"));
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModelBakers() {
        MinecraftForge.EVENT_BUS.register((Object)new ModelBakerTwinTails());
    }

    public void registerRecipes() {
        this.hairBand.AddRecipes();
    }
}

