/*
 * Decompiled with CFR 0.152.
 */
package com.hea3ven.twintails.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.hea3ven.tools.commonutils.client.BakerUtil;
import com.hea3ven.tools.commonutils.client.ModelBakerBase;
import com.hea3ven.twintails.TwinTailType;
import com.hea3ven.twintails.item.ItemHairBand;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModelBakerTwinTails
extends ModelBakerBase {
    private Map<ResourceLocation, TextureAtlasSprite> textures = Maps.newHashMap();

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        for (TwinTailType type : ItemHairBand.twinTailTypes) {
            ResourceLocation location = new ResourceLocation("twintails:models/twintails_" + type.getName());
            this.textures.put(location, event.getMap().func_174942_a(location));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (TwinTailType type : ItemHairBand.twinTailTypes) {
            IModel model = this.getModel(new ResourceLocation("twintails:twintails_" + type.getName() + ".obj"));
            if (model instanceof OBJModel) {
                model = ((OBJModel)model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            }
            IBakedModel bakedModel = BakerUtil.bake((IModel)model, (VertexFormat)DefaultVertexFormats.field_181712_l, this.textures);
            type.getModel().setModel(bakedModel);
        }
    }
}

