/*
 * Decompiled with CFR 0.152.
 */
package com.hea3ven.twintails.item;

import com.hea3ven.twintails.TwinTailType;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ItemHairBand
extends ItemArmor {
    private static final ItemArmor.ArmorMaterial hairBandArmorMaterial = ItemArmor.ArmorMaterial.CHAIN;
    public static boolean twinTailsEffects = false;
    public static TwinTailType[] twinTailTypes = new TwinTailType[]{new TwinTailType(0, "white", new Potion[0], "dyeWhite", EnumDyeColor.WHITE), new TwinTailType(1, "red", new Potion[]{MobEffects.field_76424_c, MobEffects.field_76430_j}, "dyeRed", EnumDyeColor.RED), new TwinTailType(2, "blue", new Potion[]{MobEffects.field_76427_o, MobEffects.field_76420_g}, "dyeBlue", EnumDyeColor.BLUE), new TwinTailType(3, "yellow", new Potion[]{MobEffects.field_76429_m, MobEffects.field_76426_n}, "dyeYellow", EnumDyeColor.YELLOW), new TwinTailType(4, "cyan", new Potion[0], "dyeCyan", EnumDyeColor.CYAN), new TwinTailType(5, "pink", new Potion[0], "dyePink", EnumDyeColor.PINK), new TwinTailType(6, "black", new Potion[0], "dyeBlack", EnumDyeColor.BLACK), new TwinTailType(7, "brown", new Potion[0], "dyeBrown", EnumDyeColor.BROWN)};

    public ItemHairBand() {
        super(hairBandArmorMaterial, 0, EntityEquipmentSlot.HEAD);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    private int getTypeOffset(ItemStack itemStack) {
        return this.getTypeOffset(itemStack.func_77952_i());
    }

    private int getTypeOffset(int meta) {
        return meta < twinTailTypes.length ? meta : 0;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && twinTailsEffects) {
            this.refreshPotionsEffects(player, twinTailTypes[this.getTypeOffset(itemStack)].getPotions());
        }
    }

    private void refreshPotionsEffects(EntityPlayer player, Potion[] potions) {
        for (Potion potion : potions) {
            PotionEffect effect = player.func_70660_b(potion);
            if (effect != null && effect.func_76459_b() >= 10) continue;
            player.func_70690_d(new PotionEffect(potion, 80, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped defaultModel) {
        return twinTailTypes[this.getTypeOffset(itemStack)].getModel();
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a() + "." + twinTailTypes[this.getTypeOffset(itemStack)].getName();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List itemList) {
        for (TwinTailType twinTailType : twinTailTypes) {
            itemList.add(new ItemStack(item, 1, twinTailType.getOrdinal()));
        }
    }

    public void AddRecipes() {
        ItemStack anyHairTie = new ItemStack((Item)this, 1, Short.MAX_VALUE);
        for (TwinTailType twinTailType : twinTailTypes) {
            ItemStack wool = new ItemStack(Blocks.field_150325_L, 1, twinTailType.getColor().func_176765_a());
            ItemStack typeHairTie = new ItemStack((Item)this, 1, twinTailType.getOrdinal());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(typeHairTie, new Object[]{" s ", "sbs", " s ", Character.valueOf('s'), wool, Character.valueOf('b'), "slimeball"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(typeHairTie, new Object[]{anyHairTie, twinTailType.getRecipeIngredient()}));
        }
    }
}

