/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.launcher.updater.StreamVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;

public class LocalVersionList
extends StreamVersionList {
    private File baseDirectory;
    private File baseVersionsDir;

    public LocalVersionList(File baseDirectory) throws IOException {
        this.setBaseDirectory(baseDirectory);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Base directory is NULL!");
        }
        FileUtil.createFolder(directory);
        this.log("Base directory:", directory.getAbsolutePath());
        this.baseDirectory = directory;
        this.baseVersionsDir = new File(this.baseDirectory, "versions");
    }

    @Override
    public void refreshVersions() throws IOException {
        this.clearCache();
        File[] files = this.baseVersionsDir.listFiles();
        if (files != null) {
            File[] arr$ = files;
            int len$ = files.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File directory = arr$[i$];
                String id = directory.getName();
                File jsonFile = new File(directory, id + ".json");
                if (!directory.isDirectory() || !jsonFile.isFile()) continue;
                try {
                    CompleteVersion ex = this.gson.fromJson(this.getUrl("versions/" + id + "/" + id + ".json"), CompleteVersion.class);
                    if (ex == null) {
                        this.log("JSON descriptor of version \"" + id + "\" in NULL, it won't be added in list as local.");
                        continue;
                    }
                    ex.setID(id);
                    ex.setSource(Repository.LOCAL_VERSION_REPO);
                    ex.setVersionList(this);
                    this.addVersion(ex);
                    continue;
                }
                catch (Exception var9) {
                    this.log("Error occurred while parsing local version", id, var9);
                }
            }
        }
    }

    public void saveVersion(CompleteVersion version) throws IOException {
        String text = this.serializeVersion(version);
        File target = new File(this.baseVersionsDir, version.getID() + "/" + version.getID() + ".json");
        FileUtil.writeFile(target, text);
    }

    public void deleteVersion(String id, boolean deleteLibraries) throws IOException {
        CompleteVersion version = this.getCompleteVersion(id);
        if (version == null) {
            throw new IllegalArgumentException("Version is not installed!");
        }
        File dir = new File(this.baseVersionsDir, id + '/');
        if (!dir.isDirectory()) {
            throw new IOException("Cannot find directory: " + dir.getAbsolutePath());
        }
        FileUtil.deleteDirectory(dir);
        if (deleteLibraries) {
            for (File nativeLib : version.getClassPath(this.baseDirectory)) {
                FileUtil.deleteFile(nativeLib);
            }
            for (String nativeLib1 : version.getNatives()) {
                FileUtil.deleteFile(new File(this.baseDirectory, nativeLib1));
            }
        }
    }

    @Override
    protected InputStream getInputStream(String uri) throws IOException {
        return new FileInputStream(new File(this.baseDirectory, uri));
    }

    @Override
    public boolean hasAllFiles(CompleteVersion version, OS os) {
        String file;
        File required;
        Set<String> files = version.getRequiredFiles(os);
        Iterator<String> i$ = files.iterator();
        do {
            if (i$.hasNext()) continue;
            return true;
        } while ((required = new File(this.baseDirectory, file = i$.next())).isFile() && required.length() != 0L);
        return false;
    }
}

