/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.updater.Notices;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;

class ConfigurationDefaults {
    private static final int version = 3;
    private final Map<String, Object> d = new HashMap<String, Object>();

    ConfigurationDefaults() {
        this.d.put("settings.version", 3);
        this.d.put("minecraft.gamedir", MinecraftUtil.getDefaultWorkingDirectory().getAbsolutePath());
        this.d.put("minecraft.size", new IntegerArray(925, 530));
        this.d.put("minecraft.fullscreen", false);
        for (ReleaseType len$ : ReleaseType.getDefault()) {
            this.d.put("minecraft.versions." + len$.name().toLowerCase(), true);
        }
        for (ReleaseType.SubType var6 : ReleaseType.SubType.getDefault()) {
            this.d.put("minecraft.versions.sub." + var6.name().toLowerCase(), true);
        }
        for (Notices.NoticeType type : Notices.NoticeType.values()) {
            if (!type.isAdvert()) continue;
            this.d.put("gui.notice." + type.name().toLowerCase(), true);
        }
        this.d.put("minecraft.memory", OS.Arch.PREFERRED_MEMORY);
        this.d.put("minecraft.onlaunch", (Object)Configuration.ActionOnLaunch.getDefault());
        this.d.put("gui.console", (Object)Configuration.ConsoleType.getDefault());
        this.d.put("gui.console.width", 720);
        this.d.put("gui.console.height", 500);
        this.d.put("gui.console.x", 30);
        this.d.put("gui.console.y", 30);
        this.d.put("connection", (Object)Configuration.ConnectionQuality.getDefault());
        this.d.put("client", UUID.randomUUID());
        this.d.put("gui.statistics.checkbox", false);
    }

    public static int getVersion() {
        return 3;
    }

    public Map<String, Object> getMap() {
        return Collections.unmodifiableMap(this.d);
    }

    public Object get(String key) {
        return this.d.get(key);
    }
}

