/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.browser;

import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.block.Unblockable;
import ru.turikhay.tlauncher.ui.browser.BrowserFallback;
import ru.turikhay.tlauncher.ui.browser.BrowserPanel;
import ru.turikhay.tlauncher.ui.swing.ResizeableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.util.U;

public class BrowserHolder
extends BorderPanel
implements ResizeableComponent,
Unblockable {
    private static BrowserHolder browserHolder;
    MainPane pane;
    final BrowserFallback fallback = new BrowserFallback(this);
    final BrowserPanel browser;

    private BrowserHolder() {
        BrowserPanel browser_ = null;
        try {
            browser_ = new BrowserPanel(this);
        }
        catch (Throwable var3) {
            BrowserHolder.log("Cannot load BrowserPanel. Will show BrowserFallback panel.", var3);
        }
        this.browser = browser_;
        this.setBrowserShown("fallback", this.browser != null);
    }

    public void setBrowserShown(Object reason, boolean shown) {
        if (!shown && !Blocker.isBlocked(this.fallback)) {
            this.fallback.unblock(reason);
        } else {
            Blocker.setBlocked(this.fallback, reason, shown);
        }
    }

    public void setBrowserContentShown(Object reason, boolean shown) {
        if (this.browser != null) {
            Blocker.setBlocked(this.browser, reason, !shown);
        }
    }

    @Override
    public void onResize() {
        if (this.pane == null) {
            BrowserHolder.log("pane = null so it'c can't resize");
        } else {
            int width = this.pane.getWidth();
            int height = this.pane.getHeight();
            this.setSize(width, height);
        }
    }

    private static void log(Object ... o) {
        U.log("[BrowserHolder]", o);
    }

    public MainPane getPane() {
        return this.pane;
    }

    public void setPane(MainPane pane) {
        this.pane = pane;
    }

    public static BrowserHolder getInstance() {
        if (browserHolder == null) {
            browserHolder = new BrowserHolder();
        }
        return browserHolder;
    }
}

