/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.menu;

import com.jidesoft.popup.JidePopup;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.turikhay.tlauncher.ui.menu.PopupMenuController;
import ru.turikhay.tlauncher.ui.menu.PopupMenuModel;
import ru.turikhay.tlauncher.ui.util.ViewlUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class PopupMenuView
extends JidePopup {
    private final PopupMenuController controller;
    private final PopupMenuModel menuModel;
    private final JComboBox<Object> box;
    private final JLabel label;
    private final JMenuItem title;
    private final ItemPopup start;
    private final ItemPopup copy;
    private final ItemPopup favorite;
    private static Point point;

    public PopupMenuView(PopupMenuModel model, PopupMenuController controller) {
        int leftStrut;
        if (OS.is(OS.WINDOWS)) {
            this.setPopupBorder(BorderFactory.createCompoundBorder(this.getBorder(), new EmptyBorder(0, 0, 0, 0)));
            leftStrut = 33;
        } else {
            leftStrut = 22;
            this.setPopupBorder(BorderFactory.createCompoundBorder(this.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        }
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.menuModel = model;
        this.controller = controller;
        this.setBackground(UIManager.getColor("PopupMenu.background"));
        JPanel panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel, 2);
        panel.setLayout(boxLayout);
        this.label = new JLabel(model.getVersion());
        this.box = new JComboBox<Object>(this.menuModel.getHashMap().keySet().toArray());
        this.title = new JMenuItem(ViewlUtil.addSpaces(model.getTitle(), model.getName()));
        this.start = new ItemPopup(model.getStart());
        this.copy = new ItemPopup(model.getCopy());
        this.favorite = new ItemPopup(model.getFavorite());
        this.title.setForeground(new Color(0.0f, 0.0f, 0.0f, 0.55f));
        panel.setBackground(this.start.getBackground());
        panel.add(Box.createHorizontalStrut(leftStrut));
        panel.add(this.label);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.box);
        panel.add(Box.createHorizontalStrut(10));
        this.title.setBackground(UIManager.getColor("PopupMenu.background"));
        this.add(this.title);
        this.add(this.start);
        this.add(this.copy);
        this.add(this.favorite);
        this.add(panel);
        int width = (int)this.title.getPreferredSize().getWidth();
        this.setPreferredPopupSize(new Dimension(width - 20, (int)this.getPreferredSize().getHeight() + 10));
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenuView.this.hidePopup();
                PopupMenuView.this.controller.changeVersion(PopupMenuView.this.box.getSelectedItem().toString());
                PopupMenuView.this.controller.launchGame();
            }
        });
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenuView.this.controller.copyAddress();
            }
        });
        this.favorite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenuView.this.controller.addFavorite(true);
            }
        });
        this.box.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                point = MouseInfo.getPointerInfo().getLocation();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new Robot().mouseMove(point.x, point.y);
                }
                catch (AWTException var3) {
                    PopupMenuView.this.log(var3);
                }
            }
        });
    }

    private void log(Object e) {
        U.log("[PopupMenuView] ", e);
    }

    class ItemPopup
    extends JMenuItem {
        public ItemPopup(String text) {
            super(text);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ItemPopup.this.setBackground(new Color(48, 131, 251));
                    ItemPopup.this.setForeground(Color.WHITE);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ItemPopup.this.setForeground(UIManager.getColor("MenuItem.foreground"));
                    ItemPopup.this.setBackground(UIManager.getColor("MenuItem.background"));
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    ItemPopup.this.setForeground(UIManager.getColor("MenuItem.foreground"));
                    ItemPopup.this.setBackground(UIManager.getColor("MenuItem.background"));
                }
            });
        }
    }
}

