/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.U;

public class ImagePanel
extends ExtendedPanel {
    private static final long serialVersionUID = 1L;
    public static final float DEFAULT_ACTIVE_OPACITY = 1.0f;
    public static final float DEFAULT_NON_ACTIVE_OPACITY = 0.75f;
    protected final Object animationLock = new Object();
    private Image originalImage;
    private Image image;
    private float activeOpacity;
    private float nonActiveOpacity;
    private boolean antiAlias;
    private int timeFrame;
    private float opacity;
    private boolean hover;
    private boolean shown;
    private boolean animating;

    public ImagePanel(String image, float activeOpacity, float nonActiveOpacity, boolean shown, boolean antiAlias) {
        this(ImageCache.getImage(image), activeOpacity, nonActiveOpacity, shown, antiAlias);
    }

    public ImagePanel(String image) {
        this(image, 1.0f, 0.75f, true, true);
    }

    protected ImagePanel(Image image, float activeOpacity, float nonActiveOpacity, boolean shown, boolean antiAlias) {
        this.setImage(image);
        this.setActiveOpacity(activeOpacity);
        this.setNonActiveOpacity(nonActiveOpacity);
        this.setAntiAlias(antiAlias);
        this.shown = shown;
        this.opacity = shown ? nonActiveOpacity : 0.0f;
        this.timeFrame = 10;
        this.setBackground(new Color(0, 0, 0, 0));
        this.addMouseListenerOriginally(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImagePanel.this.onClick();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ImagePanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImagePanel.this.onMouseExited();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImage(Image image, boolean resetSize) {
        Object var3 = this.animationLock;
        Object object = this.animationLock;
        synchronized (object) {
            this.originalImage = image;
            this.image = image;
            if (resetSize && image != null) {
                this.setSize(image.getWidth(null), image.getHeight(null));
            }
        }
    }

    protected void setImage(Image image) {
        this.setImage(image, true);
    }

    protected void setActiveOpacity(float opacity) {
        if (!(opacity <= 1.0f) || !(opacity >= 0.0f)) {
            throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
        }
        this.activeOpacity = opacity;
    }

    protected void setNonActiveOpacity(float opacity) {
        if (!(opacity <= 1.0f) || !(opacity >= 0.0f)) {
            throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
        }
        this.nonActiveOpacity = opacity;
    }

    protected void setAntiAlias(boolean set) {
        this.antiAlias = set;
    }

    @Override
    public void paintComponent(Graphics g0) {
        if (this.image != null) {
            Graphics2D g = (Graphics2D)g0;
            Composite oldComp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, this.opacity));
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
            g.setComposite(oldComp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        if (!this.shown) {
            this.shown = true;
            Object var1 = this.animationLock;
            Object object = this.animationLock;
            synchronized (object) {
                float selectedOpacity;
                this.animating = true;
                this.setVisible(true);
                this.opacity = 0.0f;
                float f = selectedOpacity = this.hover ? this.activeOpacity : this.nonActiveOpacity;
                while (this.opacity < selectedOpacity) {
                    this.opacity += 0.01f;
                    if (this.opacity > selectedOpacity) {
                        this.opacity = selectedOpacity;
                    }
                    this.repaint();
                    U.sleepFor(this.timeFrame);
                }
                this.animating = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hide() {
        if (this.shown) {
            this.shown = false;
            Object var1 = this.animationLock;
            Object object = this.animationLock;
            synchronized (object) {
                this.animating = true;
                while (this.opacity > 0.0f) {
                    this.opacity -= 0.01f;
                    if (this.opacity < 0.0f) {
                        this.opacity = 0.0f;
                    }
                    this.repaint();
                    U.sleepFor(this.timeFrame);
                }
                this.setVisible(false);
                this.animating = false;
            }
        }
    }

    public void setPreferredSize() {
        if (this.image != null) {
            this.setPreferredSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
        }
    }

    protected boolean onClick() {
        return this.shown;
    }

    protected void onMouseEntered() {
        this.hover = true;
        if (!this.animating && this.shown) {
            this.opacity = this.activeOpacity;
            this.repaint();
        }
    }

    protected void onMouseExited() {
        this.hover = false;
        if (!this.animating && this.shown) {
            this.opacity = this.nonActiveOpacity;
            this.repaint();
        }
    }
}

