/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.FileTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import ru.turikhay.tlauncher.component.RefreshableComponent;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ProfileManagerListener;
import ru.turikhay.tlauncher.minecraft.auth.AccountListener;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import ru.turikhay.tlauncher.minecraft.auth.UUIDTypeAdapter;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.U;

public class ProfileManager
extends RefreshableComponent {
    public static final String DEFAULT_PROFILE_NAME = "TLauncher";
    public static final String OLD_PROFILE_FILENAME = "launcher_profiles.json";
    public static final String DEFAULT_PROFILE_FILENAME = "tlauncher_profiles.json";
    private final List<ProfileManagerListener> listeners;
    private final AccountListener accountListener;
    private final Gson gson;
    private File file;
    private UUID clientToken;
    private AuthenticatorDatabase authDatabase;

    public ProfileManager(ComponentManager manager, File file) throws Exception {
        super(manager);
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.clientToken = UUID.randomUUID();
        this.accountListener = new AccountListener(){

            @Override
            public void onAccountsRefreshed(AuthenticatorDatabase db) {
                for (AccountListener listener : ProfileManager.this.listeners) {
                    listener.onAccountsRefreshed(db);
                }
            }
        };
        this.authDatabase = new AuthenticatorDatabase();
        this.authDatabase.setListener(this.accountListener);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)AuthenticatorDatabase.class), new AuthenticatorDatabase.Serializer());
        builder.registerTypeAdapter((Type)((Object)UUIDTypeAdapter.class), new UUIDTypeAdapter());
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public ProfileManager(ComponentManager manager) throws Exception {
        this(manager, ProfileManager.getDefaultFile());
    }

    public void recreate() {
        this.setFile(ProfileManager.getDefaultFile());
        this.refresh();
    }

    @Override
    public boolean refresh() {
        this.loadProfiles();
        for (ProfileManagerListener listener : this.listeners) {
            listener.onProfilesRefreshed(this);
        }
        try {
            this.saveProfiles();
            return true;
        }
        catch (IOException var3) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfiles() {
        this.log("Refreshing profiles from:", this.file);
        File oldFile = new File(this.file.getParentFile(), OLD_PROFILE_FILENAME);
        OutputStreamWriter writer = null;
        if (!oldFile.isFile()) {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(oldFile), Charset.forName("UTF-8"));
                this.gson.toJson((Object)new OldProfileList(), (Appendable)writer);
                writer.close();
            }
            catch (Exception var17) {
                try {
                    this.log("Cannot write into", OLD_PROFILE_FILENAME, var17);
                }
                catch (Throwable throwable) {
                    U.close(writer);
                    throw throwable;
                }
                U.close(writer);
            }
            U.close(writer);
        }
        RawProfileList raw = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(this.file.isFile() ? this.file : oldFile), Charset.forName("UTF-8"));
            raw = this.gson.fromJson((Reader)reader, RawProfileList.class);
        }
        catch (Exception var15) {
            try {
                this.log("Cannot read from", DEFAULT_PROFILE_FILENAME, var15);
            }
            catch (Throwable throwable) {
                U.close(reader);
                throw throwable;
            }
            U.close(reader);
        }
        U.close(reader);
        if (raw == null) {
            raw = new RawProfileList();
        }
        this.clientToken = raw.clientToken;
        this.authDatabase = raw.authenticationDatabase;
        this.authDatabase.setListener(this.accountListener);
    }

    public void saveProfiles() throws IOException {
        RawProfileList raw = new RawProfileList();
        raw.clientToken = this.clientToken;
        raw.authenticationDatabase = this.authDatabase;
        FileUtil.writeFile(this.file, this.gson.toJson(raw));
    }

    public AuthenticatorDatabase getAuthDatabase() {
        return this.authDatabase;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        for (ProfileManagerListener listener : this.listeners) {
            listener.onProfileManagerChanged(this);
        }
    }

    public UUID getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String uuid) {
        this.clientToken = UUID.fromString(uuid);
    }

    public void addListener(ProfileManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private static File getDefaultFile() {
        return new File(MinecraftUtil.getWorkingDirectory(), DEFAULT_PROFILE_FILENAME);
    }

    static class RawProfileList {
        UUID clientToken = UUID.randomUUID();
        AuthenticatorDatabase authenticationDatabase = new AuthenticatorDatabase();

        RawProfileList() {
        }
    }

    static class OldProfileList {
        UUID clientToken = UUID.randomUUID();
        Map<?, ?> profiles;

        OldProfileList() {
        }
    }
}

