/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.login.LoginWaitException;
import ru.turikhay.tlauncher.ui.swing.SimpleComboBoxModel;
import ru.turikhay.tlauncher.ui.swing.VersionCellRenderer;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;

public class VersionComboBox
extends ExtendedComboBox<VersionSyncInfo>
implements Blockable,
VersionManagerListener,
LocalizableComponent,
LoginForm.LoginProcessListener {
    private static final long serialVersionUID = -9122074452728842733L;
    static boolean showElyVersions;
    private static final VersionSyncInfo LOADING;
    private static final VersionSyncInfo EMPTY;
    private final VersionManager manager;
    private final LoginForm loginForm;
    private final SimpleComboBoxModel<VersionSyncInfo> model;
    private String selectedVersion;

    VersionComboBox(LoginForm lf) {
        super(new VersionCellRenderer(){

            @Override
            public boolean getShowElyVersions() {
                return showElyVersions;
            }
        });
        this.loginForm = lf;
        this.model = this.getSimpleModel();
        this.manager = TLauncher.getInstance().getVersionManager();
        this.manager.addListener(this);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VersionComboBox)VersionComboBox.this).loginForm.play.updateState();
                VersionSyncInfo selected = VersionComboBox.this.getVersion();
                if (selected != null) {
                    VersionComboBox.this.selectedVersion = selected.getID();
                }
            }
        });
        this.selectedVersion = lf.global.get("login.version");
    }

    public VersionSyncInfo getVersion() {
        VersionSyncInfo selected = (VersionSyncInfo)this.getSelectedItem();
        return selected != null && !selected.equals(LOADING) && !selected.equals(EMPTY) ? selected : null;
    }

    @Override
    public void logginingIn() throws LoginException {
        VersionSyncInfo selected = this.getVersion();
        if (selected == null) {
            throw new LoginWaitException("Version list is empty, refreshing", new LoginWaitException.LoginWaitTask(){

                @Override
                public void runTask() throws LoginException {
                    VersionComboBox.this.manager.refresh();
                    if (VersionComboBox.this.getVersion() == null) {
                        Alert.showLocError("versions.notfound");
                    }
                    throw new LoginException("Giving user a second chance to choose correct version...");
                }
            });
        }
        if (selected.hasRemote() && selected.isInstalled() && !selected.isUpToDate()) {
            if (!Alert.showLocQuestion("versions.found-update")) {
                try {
                    CompleteVersion e = this.manager.getLocalList().getCompleteVersion(selected.getLocal());
                    e.setUpdatedTime(selected.getLatestVersion().getUpdatedTime());
                    this.manager.getLocalList().saveVersion(e);
                }
                catch (IOException var3) {
                    Alert.showLocError("versions.found-update.error");
                }
            } else {
                this.loginForm.checkbox.forceupdate.setSelected(true);
            }
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }

    @Override
    public void updateLocale() {
        this.updateList(this.manager.getVersions(), null);
    }

    @Override
    public void onVersionsRefreshing(VersionManager vm) {
        this.updateList(null, null);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager vm) {
        this.updateList(this.manager.getVersions(), null);
    }

    @Override
    public void onVersionsRefreshed(VersionManager vm) {
        this.updateList(this.manager.getVersions(), null);
    }

    void updateList(List<VersionSyncInfo> list, String select) {
        if (select == null && this.selectedVersion != null) {
            select = this.selectedVersion;
        }
        this.removeAllItems();
        if (list == null) {
            this.addItem(LOADING);
        } else if (list.isEmpty()) {
            this.addItem(EMPTY);
        } else {
            this.model.addElements(list);
            for (VersionSyncInfo version : list) {
                if (select == null || !version.getID().equals(select)) continue;
                this.setSelectedItem(version);
            }
        }
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    static {
        LOADING = VersionCellRenderer.LOADING;
        EMPTY = VersionCellRenderer.EMPTY;
    }
}

