/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import java.awt.Color;
import java.util.StringTokenizer;

public class RgbColorConverter
extends ColorConverter {
    private boolean _alphaIncluded = false;

    public RgbColorConverter() {
    }

    public RgbColorConverter(boolean alphaIncluded) {
        this._alphaIncluded = alphaIncluded;
    }

    public boolean isAlphaIncluded() {
        return this._alphaIncluded;
    }

    public void setAlphaIncluded(boolean alphaIncluded) {
        this._alphaIncluded = alphaIncluded;
    }

    public String toString(Object object, ConverterContext context) {
        if (object instanceof Color) {
            Color color = (Color)object;
            StringBuffer colorText = new StringBuffer();
            colorText.append(color.getRed()).append(", ");
            colorText.append(color.getGreen()).append(", ");
            colorText.append(color.getBlue());
            if (this.isAlphaIncluded()) {
                colorText.append(", ").append(color.getAlpha());
            }
            return new String(colorText);
        }
        return "";
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public Object fromString(String string, ConverterContext context) {
        String s;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(string, ",; ");
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        if (token.hasMoreTokens()) {
            s = token.nextToken();
            try {
                r = Integer.parseInt(s, 10) % 256;
                if (r < 0) {
                    r += 256;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (token.hasMoreTokens()) {
            s = token.nextToken();
            try {
                g = Integer.parseInt(s, 10) % 256;
                if (g < 0) {
                    g += 256;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (token.hasMoreTokens()) {
            s = token.nextToken();
            try {
                b = Integer.parseInt(s, 10) % 256;
                if (b < 0) {
                    b += 256;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.isAlphaIncluded() && token.hasMoreTokens()) {
            s = token.nextToken();
            try {
                a = Integer.parseInt(s, 10) % 256;
                if (a < 0) {
                    a += 256;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new Color(r, g, b, a);
    }
}

