/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.OS;

public class RepositoryBasedVersionList
extends RemoteVersionList {
    private final Repository repository;

    RepositoryBasedVersionList(Repository repository) {
        if (repository == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
    }

    @Override
    public VersionList.RawVersionList getRawList() throws IOException {
        VersionList.RawVersionList rawList = super.getRawList();
        for (Version version : rawList.getVersions()) {
            version.setSource(this.repository);
        }
        return rawList;
    }

    @Override
    public CompleteVersion getCompleteVersion(Version version) throws JsonSyntaxException, IOException {
        CompleteVersion complete = super.getCompleteVersion(version);
        complete.setSource(this.repository);
        return complete;
    }

    @Override
    public boolean hasAllFiles(CompleteVersion paramCompleteVersion, OS paramOperatingSystem) {
        return true;
    }

    @Override
    protected String getUrl(String uri) throws IOException {
        return this.repository.getUrl(uri);
    }
}

